/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.Delegate;
import org.apache.yoko.orb.OB.BootLocator;
import org.apache.yoko.orb.OB.BootManager;
import org.apache.yoko.orb.OB.BootManagerPackage.AlreadyExists;
import org.apache.yoko.orb.OB.BootManagerPackage.NotFound;
import org.apache.yoko.orb.OB.IORUtil;
import org.apache.yoko.orb.OB.ObjectIdHasher;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.IOR;

public final class BootManager_impl
extends LocalObject
implements BootManager {
    static final Logger logger = Logger.getLogger(BootManager_impl.class.getName());
    private Hashtable bindings_ = new Hashtable(17);
    private BootLocator locator_ = null;
    private ORB orb_;

    public BootManager_impl(ORB orb) {
        this.orb_ = orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add_binding(byte[] id, Object obj) throws AlreadyExists {
        ObjectIdHasher oid = new ObjectIdHasher(id);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding binding under id " + IORUtil.dump_octets(id));
        }
        Hashtable hashtable = this.bindings_;
        synchronized (hashtable) {
            if (this.bindings_.containsKey(oid)) {
                throw new AlreadyExists();
            }
            this.bindings_.put(oid, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove_binding(byte[] id) throws NotFound {
        ObjectIdHasher oid = new ObjectIdHasher(id);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing binding with id " + IORUtil.dump_octets(id));
        }
        Hashtable hashtable = this.bindings_;
        synchronized (hashtable) {
            if (this.bindings_.remove(oid) == null) {
                throw new NotFound();
            }
        }
    }

    @Override
    public void set_locator(BootLocator locator) {
        this.locator_ = locator;
    }

    public IOR _OB_locate(byte[] id) {
        Object obj;
        ObjectIdHasher oid = new ObjectIdHasher(id);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Searching for binding with id " + IORUtil.dump_octets(id));
        }
        if ((obj = (Object)this.bindings_.get(oid)) == null && this.locator_ != null) {
            logger.fine("Object not found, passing on to locator");
            try {
                ObjectHolder objHolder = new ObjectHolder();
                BooleanHolder addHolder = new BooleanHolder();
                this.locator_.locate(id, objHolder, addHolder);
                obj = objHolder.value;
                if (addHolder.value) {
                    this.bindings_.put(oid, obj);
                }
            }
            catch (NotFound objHolder) {
                // empty catch block
            }
        }
        if (obj == null) {
            String keyString = new String(id);
            try {
                obj = this.orb_.resolve_initial_references(keyString);
            }
            catch (InvalidName ex) {
                return null;
            }
            if (obj == null) {
                return null;
            }
        }
        Delegate p = (Delegate)((ObjectImpl)obj)._get_delegate();
        return p._OB_IOR();
    }
}

