/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.ASN1OctetString;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERBoolean;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERObjectIdentifier;
import com.ibm.ws.transport.iiop.asn1.DERSequence;
import com.ibm.ws.transport.iiop.asn1.x509.X509Extension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class X509Extensions
extends ASN1Encodable {
    public static final DERObjectIdentifier SubjectDirectoryAttributes;
    public static final DERObjectIdentifier SubjectKeyIdentifier;
    public static final DERObjectIdentifier KeyUsage;
    public static final DERObjectIdentifier PrivateKeyUsagePeriod;
    public static final DERObjectIdentifier SubjectAlternativeName;
    public static final DERObjectIdentifier IssuerAlternativeName;
    public static final DERObjectIdentifier BasicConstraints;
    public static final DERObjectIdentifier CRLNumber;
    public static final DERObjectIdentifier ReasonCode;
    public static final DERObjectIdentifier InstructionCode;
    public static final DERObjectIdentifier InvalidityDate;
    public static final DERObjectIdentifier DeltaCRLIndicator;
    public static final DERObjectIdentifier IssuingDistributionPoint;
    public static final DERObjectIdentifier CertificateIssuer;
    public static final DERObjectIdentifier NameConstraints;
    public static final DERObjectIdentifier CRLDistributionPoints;
    public static final DERObjectIdentifier CertificatePolicies;
    public static final DERObjectIdentifier PolicyMappings;
    public static final DERObjectIdentifier AuthorityKeyIdentifier;
    public static final DERObjectIdentifier PolicyConstraints;
    public static final DERObjectIdentifier ExtendedKeyUsage;
    public static final DERObjectIdentifier FreshestCRL;
    public static final DERObjectIdentifier InhibitAnyPolicy;
    public static final DERObjectIdentifier AuthorityInfoAccess;
    public static final DERObjectIdentifier SubjectInfoAccess;
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();
    static final long serialVersionUID = -5061580048718548187L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static X509Extensions getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X509Extensions.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static X509Extensions getInstance(Object obj) {
        if (obj == null || obj instanceof X509Extensions) {
            return (X509Extensions)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new X509Extensions((ASN1Sequence)obj);
        }
        if (obj instanceof ASN1TaggedObject) {
            return X509Extensions.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public X509Extensions(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence s = (ASN1Sequence)e.nextElement();
            if (s.size() == 3) {
                this.extensions.put(s.getObjectAt(0), new X509Extension((DERBoolean)s.getObjectAt(1), (ASN1OctetString)s.getObjectAt(2)));
            } else {
                this.extensions.put(s.getObjectAt(0), new X509Extension(false, (ASN1OctetString)s.getObjectAt(1)));
            }
            this.ordering.addElement(s.getObjectAt(0));
        }
    }

    public X509Extensions(Hashtable extensions) {
        this(null, extensions);
    }

    public X509Extensions(Vector ordering, Hashtable extensions) {
        Enumeration<Object> e = ordering == null ? extensions.keys() : ordering.elements();
        while (e.hasMoreElements()) {
            this.ordering.addElement(e.nextElement());
        }
        e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)extensions.get(oid);
            this.extensions.put(oid, ext);
        }
    }

    public X509Extensions(Vector objectIDs, Vector values) {
        Enumeration e = objectIDs.elements();
        while (e.hasMoreElements()) {
            this.ordering.addElement(e.nextElement());
        }
        int count = 0;
        e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)values.elementAt(count);
            this.extensions.put(oid, ext);
            ++count;
        }
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public X509Extension getExtension(DERObjectIdentifier oid) {
        return (X509Extension)this.extensions.get(oid);
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Enumeration e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)this.extensions.get(oid);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(oid);
            if (ext.isCritical()) {
                v.add(new DERBoolean(true));
            }
            v.add(ext.getValue());
            vec.add(new DERSequence(v));
        }
        return new DERSequence(vec);
    }

    @Override
    public int hashCode() {
        Enumeration e = this.extensions.keys();
        int hashCode = 0;
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            hashCode ^= o.hashCode();
            hashCode ^= this.extensions.get(o).hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof X509Extensions)) {
            return false;
        }
        X509Extensions other = (X509Extensions)o;
        Enumeration e1 = this.extensions.keys();
        Enumeration e2 = other.extensions.keys();
        while (e1.hasMoreElements() && e2.hasMoreElements()) {
            Object o2;
            Object o1 = e1.nextElement();
            if (o1.equals(o2 = e2.nextElement())) continue;
            return false;
        }
        return !e1.hasMoreElements() && !e2.hasMoreElements();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.asn1.x509.X509Extensions", X509Extensions.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
        SubjectDirectoryAttributes = new DERObjectIdentifier("2.5.29.9");
        SubjectKeyIdentifier = new DERObjectIdentifier("2.5.29.14");
        KeyUsage = new DERObjectIdentifier("2.5.29.15");
        PrivateKeyUsagePeriod = new DERObjectIdentifier("2.5.29.16");
        SubjectAlternativeName = new DERObjectIdentifier("2.5.29.17");
        IssuerAlternativeName = new DERObjectIdentifier("2.5.29.18");
        BasicConstraints = new DERObjectIdentifier("2.5.29.19");
        CRLNumber = new DERObjectIdentifier("2.5.29.20");
        ReasonCode = new DERObjectIdentifier("2.5.29.21");
        InstructionCode = new DERObjectIdentifier("2.5.29.23");
        InvalidityDate = new DERObjectIdentifier("2.5.29.24");
        DeltaCRLIndicator = new DERObjectIdentifier("2.5.29.27");
        IssuingDistributionPoint = new DERObjectIdentifier("2.5.29.28");
        CertificateIssuer = new DERObjectIdentifier("2.5.29.29");
        NameConstraints = new DERObjectIdentifier("2.5.29.30");
        CRLDistributionPoints = new DERObjectIdentifier("2.5.29.31");
        CertificatePolicies = new DERObjectIdentifier("2.5.29.32");
        PolicyMappings = new DERObjectIdentifier("2.5.29.33");
        AuthorityKeyIdentifier = new DERObjectIdentifier("2.5.29.35");
        PolicyConstraints = new DERObjectIdentifier("2.5.29.36");
        ExtendedKeyUsage = new DERObjectIdentifier("2.5.29.37");
        FreshestCRL = new DERObjectIdentifier("2.5.29.46");
        InhibitAnyPolicy = new DERObjectIdentifier("2.5.29.54");
        AuthorityInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.1");
        SubjectInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.11");
    }
}

