/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitSectionException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.PeerLostLogOwnershipException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class SQLRecoverableUnitImpl
implements RecoverableUnit {
    private static final TraceComponent tc = Tr.register(SQLRecoverableUnitImpl.class, (String)"Transaction", null);
    private final long _identity;
    private final HashMap<Integer, SQLRecoverableUnitSectionImpl> _recoverableUnitSections;
    private final SQLMultiScopeRecoveryLog _recLog;
    private final byte[] _deflatedFailureScope;
    private final FailureScope _failureScope;
    private final String _serverName;
    private final String _clientName;
    private final int _clientVersion;
    private final String _logName;
    private final int _logIdentifier;
    private final String _traceId;
    final boolean _recovered;

    public SQLRecoverableUnitImpl(SQLMultiScopeRecoveryLog recLog, long identity, FailureScope failureScope, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLRecoverableUnitImpl", (Object)new Object[]{recLog, new Long(identity), failureScope, new Boolean(recovered)});
        }
        this._deflatedFailureScope = FailureScopeManager.toByteArray((FailureScope)failureScope);
        this._failureScope = failureScope;
        this._identity = identity;
        this._recLog = recLog;
        this._recovered = recovered;
        this._recoverableUnitSections = new HashMap();
        this._recLog.addRecoverableUnit(this, recovered);
        this._serverName = recLog.serverName();
        this._clientName = recLog.clientName();
        this._clientVersion = recLog.clientVersion();
        this._logName = recLog.logName();
        this._logIdentifier = recLog.logIdentifier();
        this._traceId = "SQLRecoverableUnitImpl:serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLRecoverableUnitImpl", (Object)this);
        }
    }

    SQLRecoverableUnitImpl(SQLMultiScopeRecoveryLog recLog, long identity, FailureScope failureScope) {
        this(recLog, identity, failureScope, false);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLRecoverableUnitImpl", (Object)new Object[]{recLog, new Long(identity), failureScope});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLRecoverableUnitImpl", (Object)this);
        }
    }

    public RecoverableUnitSection createSection(int identity, boolean singleData) throws RecoverableUnitSectionExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSection", (Object)new Object[]{this, new Integer(identity), new Boolean(singleData)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection", (Object)this);
            }
            throw this._recLog.getFailureException();
        }
        Integer sectionId = new Integer(identity);
        SQLRecoverableUnitSectionImpl recoverableUnitSection = null;
        if (!this._recoverableUnitSections.containsKey(sectionId)) {
            recoverableUnitSection = new SQLRecoverableUnitSectionImpl(this._recLog, this, this._identity, identity, singleData);
            this._recoverableUnitSections.put(sectionId, recoverableUnitSection);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("SQLRecoverableUnitImpl '" + this._identity + "' created a new RecoverableUnitSection with identity '" + identity + "'"));
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("SQLRecoverableUnitImpl '" + this._identity + "' was unable to create a RecoverableUnitSection with id '" + identity + "' as it already exists"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection", (Object)"RecoverableUnitSectionExistsException");
            }
            throw new RecoverableUnitSectionExistsException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSection", (Object)recoverableUnitSection);
        }
        return recoverableUnitSection;
    }

    public void removeSection(int identity) throws InvalidRecoverableUnitSectionException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSection", (Object)new Object[]{this, new Integer(identity)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeSection", (Object)"UnsupportedOperationException");
        }
        throw new UnsupportedOperationException();
    }

    public RecoverableUnitSection lookupSection(int identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupSection", (Object)new Object[]{this, new Integer(identity)});
        }
        SQLRecoverableUnitSectionImpl recoverableUnitSection = this._recoverableUnitSections.get(new Integer(identity));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupSection", (Object)recoverableUnitSection);
        }
        return recoverableUnitSection;
    }

    public void writeSections() throws InternalLogException {
        this.writeSections(false);
    }

    void writeSections(boolean rewriteRequired) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeSections", (Object)new Object[]{this, new Boolean(rewriteRequired)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSections", (Object)"InternalLogException");
            }
            throw this._recLog.getFailureException();
        }
        Iterator<SQLRecoverableUnitSectionImpl> recoverableUnitSectionsIterator = this._recoverableUnitSections.values().iterator();
        this._recLog.writeSections(recoverableUnitSectionsIterator);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeSections");
        }
    }

    public void forceSections() throws InternalLogException {
        this.forceSections(false);
    }

    void forceSections(boolean rewriteRequired) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forceSections", (Object)new Object[]{this, new Boolean(rewriteRequired)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)this);
            }
            throw this._recLog.getFailureException();
        }
        try {
            this.writeSections(rewriteRequired);
            this._recLog.forceSections();
        }
        catch (PeerLostLogOwnershipException ple) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)((Object)ple));
            }
            throw ple;
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLRecoverableUnitImpl.forceSections", (String)"531", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)((Object)exc));
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLRecoverableUnitImpl.forceSections", (String)"537", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forceSections");
        }
    }

    public LogCursor sections() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sections", (Object)this);
        }
        Collection<SQLRecoverableUnitSectionImpl> recoverableUnitSectionsValues = this._recoverableUnitSections.values();
        LogCursorImpl cursor = new LogCursorImpl(null, recoverableUnitSectionsValues, false, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sections", (Object)cursor);
        }
        return cursor;
    }

    public long identity() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"identity", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"identity", (Object)new Long(this._identity));
        }
        return this._identity;
    }

    void remove() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"remove", (Object)this);
            }
            throw this._recLog.getFailureException();
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Remove completed for recoverable unit " + this._identity + ". Clear internal state"));
        }
        this._recoverableUnitSections.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    protected FailureScope failureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"failureScope", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"failureScope", (Object)this._failureScope);
        }
        return this._failureScope;
    }

    public String toString() {
        return this._traceId;
    }
}

