/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ProxyQueueConversationGroupImpl;
import com.ibm.ws.sib.comms.common.CommsDiagnosticModule;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClientCommsDiagnosticModule
extends CommsDiagnosticModule {
    private static final TraceComponent tc = SibTr.register(ClientCommsDiagnosticModule.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static ClientCommsDiagnosticModule _clientSingleton = null;

    public static ClientCommsDiagnosticModule getInstance() {
        if (_clientSingleton == null) {
            _clientSingleton = new ClientCommsDiagnosticModule();
        }
        return _clientSingleton;
    }

    protected ClientCommsDiagnosticModule() {
    }

    @Override
    protected void dumpJFapClientStatus(IncidentStream is) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpJFapClientStatus");
        }
        ClientConnectionManager ccm = ClientConnectionManager.getRef();
        List obc = ccm.getActiveOutboundConversationsForFfdc();
        is.writeLine("\n------ Client Conversation Dump ------ ", ">");
        if (obc != null) {
            Map<Object, LinkedList<Conversation>> connectionToConversationMap = this.convertToMap(is, obc);
            for (Map.Entry<Object, LinkedList<Conversation>> entry : connectionToConversationMap.entrySet()) {
                is.writeLine("\nOutbound connection:", entry.getKey());
                LinkedList<Conversation> conversationList = entry.getValue();
                while (!conversationList.isEmpty()) {
                    Conversation c = conversationList.removeFirst();
                    is.writeLine("\nOutbound Conversation[" + c.getId() + "]: ", c.getFullSummary());
                    try {
                        this.dumpClientConversation(is, c);
                    }
                    catch (Throwable t) {
                        is.writeLine("\nUnable to dump conversation", (Object)t);
                    }
                }
            }
        } else {
            is.writeLine("\nUnable to fetch list of conversations", "");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpJFapClientStatus");
        }
    }

    @Override
    protected void dumpJFapServerStatus(IncidentStream is) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpJFapServerStatus", (Object)is);
        }
        is.writeLine("No Server Conversation Dump", "");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpJFapServerStatus");
        }
    }

    private void dumpClientConversation(IncidentStream is, Conversation conv) throws SIException {
        ClientConversationState convState = (ClientConversationState)conv.getAttachment();
        SICoreConnection siConn = convState.getSICoreConnection();
        if (siConn == null) {
            is.writeLine("  ** No SICoreConnection in ConversationState **", "(Conversation is initializing?)");
        } else {
            is.writeLine("  Connected using: ", (Object)convState.getCommsConnection());
            is.writeLine("  Connected to ME: ", siConn.getMeName() + " [" + siConn.getMeUuid() + "]");
            is.writeLine("  Resolved UserId: ", siConn.getResolvedUserid());
            is.writeLine("  ME is version ", siConn.getApiLevelDescription());
            ProxyQueueConversationGroupImpl pqgroup = (ProxyQueueConversationGroupImpl)convState.getProxyQueueConversationGroup();
            if (pqgroup == null) {
                is.writeLine("  Number of proxy queues found", "0");
            } else {
                Map map = pqgroup.getProxyQueues();
                Map idToProxyQueueMap = (Map)((HashMap)map).clone();
                is.writeLine("  Number of proxy queues found", idToProxyQueueMap.size());
                for (ProxyQueue pq : idToProxyQueueMap.values()) {
                    is.writeLine("  ", (Object)pq);
                }
            }
            is.introspectAndWriteLine("Introspection of the conversation state:", (Object)convState);
        }
    }

    protected Map<Object, LinkedList<Conversation>> convertToMap(IncidentStream is, List obc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"convertToMap", (Object)new Object[]{is, obc});
        }
        HashMap<Object, LinkedList<Conversation>> connectionToConversationMap = new HashMap<Object, LinkedList<Conversation>>();
        Iterator i = obc.iterator();
        while (i.hasNext()) {
            try {
                LinkedList conversationList;
                Conversation c = (Conversation)i.next();
                ConnectionInterface connectionObject = c.getConnectionReference();
                if (!connectionToConversationMap.containsKey(connectionObject)) {
                    conversationList = new LinkedList();
                    connectionToConversationMap.put(connectionObject, conversationList);
                } else {
                    conversationList = (LinkedList)connectionToConversationMap.get(connectionObject);
                }
                conversationList.add(c);
            }
            catch (Throwable t) {
                is.writeLine("\nUnable to dump conversation", (Object)t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"convertToMap", connectionToConversationMap);
        }
        return connectionToConversationMap;
    }
}

