/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsHealthMonitor;
import com.ibm.ws.sib.admin.JsMonitoredComponent;
import com.ibm.ws.sib.admin.JsReloadableComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.Membership;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreInterface;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public abstract class MessageStore
implements JsEngineComponent,
JsMonitoredComponent,
JsHealthMonitor,
JsReloadableComponent,
MessageStoreInterface {
    private static final String MSGSTORE_CLASS_NAME = "com.ibm.ws.sib.msgstore.impl.MessageStoreImpl";
    private static TraceComponent tc = SibTr.register(MessageStore.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    protected List<Exception> _startupExceptions = new ArrayList<Exception>();
    protected boolean _hasRedeliveryCountColumn = false;
    public volatile boolean isServerStopping = false;

    public static final MessageStore createInstance() throws ConfigurationError, RuntimeError, ConfigurationWarning, RuntimeWarning {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInstance");
        }
        MessageStore messageStore = null;
        try {
            messageStore = (MessageStore)Class.forName(MSGSTORE_CLASS_NAME).newInstance();
        }
        catch (InstantiationException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"134");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createInstance");
            }
            throw new ConfigurationError((Throwable)e1);
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"137");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createInstance");
            }
            throw new ConfigurationError((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"140");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createInstance");
            }
            throw new ConfigurationError((Throwable)e);
        }
        catch (SecurityException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"143");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createInstance");
            }
            throw new ConfigurationError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"146");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createInstance");
            }
            throw new ConfigurationError((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInstance", (Object)messageStore);
        }
        return messageStore;
    }

    protected MessageStore() {
    }

    protected Membership _getMembership(AbstractItem item) {
        return item._getMembership();
    }

    protected void _setMembership(Membership membership, AbstractItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_setMembership", (Object)new Object[]{membership, item});
        }
        item._setMembership(membership);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_setMembership");
        }
    }

    public List<Exception> getStartupExceptions() {
        return this._startupExceptions;
    }

    public void setStartupException(Exception exception) {
        this._startupExceptions.add(exception);
    }

    @Override
    public void add(ItemStream itemStream, Transaction transaction) throws MessageStoreException {
        this.add(itemStream, -2L, transaction);
    }

    @Override
    public void expirerStart() throws SevereMessageStoreException {
    }

    @Override
    public void expirerStop() {
    }

    @Override
    public void deliveryDelayManagerStart() throws SevereMessageStoreException {
    }

    @Override
    public void deliveryDelayManagerStop() {
    }

    protected abstract Membership getMembership(long var1);

    @Override
    public void serverStarted() {
    }

    @Override
    public void serverStopping() {
        this.isServerStopping = true;
    }

    public void start() throws Exception {
        this.start(0);
    }

    @Override
    public final void xmlRequestWriteOnFile(FormattedWriter writer) throws IOException {
        this.xmlWriteOn(writer);
        writer.flush();
    }

    @Override
    public final void xmlRequestWriteOnSystemOut() throws IOException {
        FormattedWriter writer = new FormattedWriter((Writer)new OutputStreamWriter(System.out));
        this.xmlWriteOn(writer);
        writer.flush();
    }

    public final void xmlRequestWriteRawDataOnFile(FormattedWriter writer) throws IOException {
        this.xmlWriteRawOn(writer, false);
        writer.flush();
    }

    public final void xmlRequestWriteRawDataOnSystemOut() throws IOException {
        FormattedWriter writer = new FormattedWriter((Writer)new OutputStreamWriter(System.out));
        this.xmlWriteRawOn(writer, false);
        writer.flush();
    }

    public void xmlWriteRawOn(FormattedWriter writer, boolean callBackToItem) throws IOException {
    }

    public boolean isRedeliveryCountColumnAvailable() {
        return this._hasRedeliveryCountColumn;
    }

    public void setRedeliveryCountColumn(boolean hasRedeliveryCountColumn) {
        this._hasRedeliveryCountColumn = hasRedeliveryCountColumn;
    }
}

