/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import com.holdenkarau.spark.testing.ColumnGenerator;
import com.holdenkarau.spark.testing.ColumnGeneratorBase;
import com.holdenkarau.spark.testing.ColumnList;
import com.holdenkarau.spark.testing.MLUserDefinedType$;
import com.holdenkarau.spark.testing.RDDGenerator$;
import java.io.Serializable;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalacheck.Arbitrary;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.util.Buildable$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DataFrameGenerator$ {
    public static final DataFrameGenerator$ MODULE$ = new DataFrameGenerator$();

    public Arbitrary<Dataset<Row>> arbitraryDataFrame(SQLContext sqlContext, StructType schema, int minPartitions) {
        return this.arbitraryDataFrameWithCustomFields(sqlContext, schema, minPartitions, (Seq<ColumnGeneratorBase>)Nil$.MODULE$);
    }

    public int arbitraryDataFrame$default$3() {
        return 1;
    }

    public Arbitrary<Dataset<Row>> arbitraryDataFrameWithCustomFields(SQLContext sqlContext, StructType schema, int minPartitions, Seq<ColumnGeneratorBase> userGenerators) {
        Gen arbitraryRDDs = RDDGenerator$.MODULE$.genRDD(sqlContext.sparkContext(), minPartitions, (Function0 & Serializable)() -> MODULE$.getRowGenerator(schema, userGenerators), ClassTag$.MODULE$.apply(Row.class));
        return Arbitrary$.MODULE$.apply((Function0 & Serializable)() -> arbitraryRDDs.map((Function1 & Serializable)r -> sqlContext.createDataFrame(r, schema)));
    }

    public int arbitraryDataFrameWithCustomFields$default$3() {
        return 1;
    }

    public Gen<Row> getRowGenerator(StructType schema) {
        return this.getRowGenerator(schema, (Seq<ColumnGeneratorBase>)Nil$.MODULE$);
    }

    public Gen<Row> getRowGenerator(StructType schema, Seq<ColumnGeneratorBase> customGenerators) {
        List<Gen<Object>> generators = this.createGenerators(schema.fields(), customGenerators);
        Gen listGen = Gen$.MODULE$.sequence(generators, Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory()));
        Gen generator = listGen.map((Function1 & Serializable)list -> Row$.MODULE$.fromSeq((Seq)list));
        return generator;
    }

    private List<Gen<Object>> createGenerators(StructField[] fields, Seq<ColumnGeneratorBase> userGenerators) {
        Map generatorMap = ((IterableOnceOps)userGenerators.map((Function1 & Serializable)generator -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)generator.columnName()), generator))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return Predef$.MODULE$.wrapRefArray((Object[])fields).toList().map((Function1 & Serializable)field -> {
            if (generatorMap.contains((Object)field.name())) {
                ColumnGeneratorBase list;
                boolean bl = false;
                Some some = null;
                Option option = generatorMap.get((Object)field.name());
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    ColumnGeneratorBase gen = (ColumnGeneratorBase)some.value();
                    if (gen instanceof ColumnGenerator) {
                        ColumnGenerator columnGenerator = (ColumnGenerator)gen;
                        return columnGenerator.gen();
                    }
                }
                if (bl && (list = (ColumnGeneratorBase)some.value()) instanceof ColumnList) {
                    ColumnList columnList = (ColumnList)list;
                    return MODULE$.getGenerator(field.dataType(), columnList.gen(), field.nullable());
                }
                throw new MatchError((Object)option);
            }
            DataType x$1 = field.dataType();
            boolean x$2 = field.nullable();
            Seq<ColumnGeneratorBase> x$3 = MODULE$.getGenerator$default$2();
            return MODULE$.getGenerator(x$1, x$3, x$2);
        });
    }

    private Gen<Object> getGenerator(DataType dataType, Seq<ColumnGeneratorBase> generators, boolean nullable) {
        Option<Gen<Object>> option;
        Gen gen;
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbByte());
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbShort());
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbInt());
        } else if (LongType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbLong());
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbFloat());
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbDouble());
        } else if (StringType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbString());
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbByte(), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Byte())), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)));
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbBool());
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbLong()).map((Function1 & Serializable)l -> DataFrameGenerator$.$anonfun$getGenerator$2(BoxesRunTime.unboxToLong((Object)l)));
        } else if (DateType$.MODULE$.equals(dataType2)) {
            gen = Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1 & Serializable)l -> DataFrameGenerator$.$anonfun$getGenerator$3(BoxesRunTime.unboxToLong((Object)l)));
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            gen = Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbBigDecimal()).retryUntil((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataFrameGenerator$.$anonfun$getGenerator$4(decimalType, d))).map((Function1 & Serializable)x$1 -> x$1.bigDecimal().setScale(decimalType.scale(), RoundingMode.HALF_UP));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType x$12 = arrayType.elementType();
            boolean x$2 = arrayType.containsNull();
            Seq<ColumnGeneratorBase> x$3 = this.getGenerator$default$2();
            Gen<Object> elementGenerator = this.getGenerator(x$12, x$3, x$2);
            gen = Gen$.MODULE$.listOf((Function0 & Serializable)() -> elementGenerator);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            Gen<Object> keyGenerator = this.getGenerator(mapType.keyType(), this.getGenerator$default$2(), this.getGenerator$default$3());
            DataType x$4 = mapType.valueType();
            boolean x$5 = mapType.valueContainsNull();
            Seq<ColumnGeneratorBase> x$6 = this.getGenerator$default$2();
            Gen<Object> valueGenerator = this.getGenerator(x$4, x$6, x$5);
            Gen keyValueGenerator = keyGenerator.flatMap((Function1 & Serializable)key -> valueGenerator.map((Function1 & Serializable)value -> new Tuple2(key, value)));
            gen = Gen$.MODULE$.mapOf((Function0 & Serializable)() -> keyValueGenerator);
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            gen = this.getRowGenerator(structType, generators);
        } else if (dataType2 != null && !(option = MLUserDefinedType$.MODULE$.unapply(dataType2)).isEmpty()) {
            Gen generator;
            gen = generator = (Gen)option.get();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(20).append("Type: ").append(dataType).append(" not supported").toString());
        }
        Gen nonNullGen = gen;
        if (nullable) {
            DataType dataType3 = dataType;
            if (dataType3 instanceof ArrayType) {
                return nonNullGen;
            }
            return Gen$.MODULE$.oneOf(nonNullGen, Gen$.MODULE$.const(null), (Seq)Nil$.MODULE$);
        }
        return nonNullGen;
    }

    private Seq<ColumnGeneratorBase> getGenerator$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    private boolean getGenerator$default$3() {
        return false;
    }

    public static final /* synthetic */ Timestamp $anonfun$getGenerator$2(long l) {
        return new Timestamp(l / 10000L);
    }

    public static final /* synthetic */ Date $anonfun$getGenerator$3(long l) {
        return new Date(l / 10000L);
    }

    public static final /* synthetic */ boolean $anonfun$getGenerator$4(DecimalType x13$1, BigDecimal d) {
        boolean bl;
        try {
            Decimal sd = new Decimal();
            sd.set(d, x13$1.precision(), x13$1.scale());
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private DataFrameGenerator$() {
    }
}

