/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser.exp;

import com.helger.pgcc.parser.Nfa;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.exp.AbstractExpRegularExpression;
import com.helger.pgcc.parser.exp.ExpRSequence;
import com.helger.pgcc.parser.exp.ExpRZeroOrMore;
import com.helger.pgcc.parser.exp.ExpRZeroOrOne;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class ExpRRepetitionRange
extends AbstractExpRegularExpression {
    private final AbstractExpRegularExpression m_regexpr;
    private int m_min = 0;
    private int m_max = -1;
    private final boolean m_hasMax;

    public ExpRRepetitionRange(Token token, int n, int n2, boolean bl, AbstractExpRegularExpression abstractExpRegularExpression) {
        this.setLine(token.beginLine);
        this.setColumn(token.beginColumn);
        this.m_min = n;
        this.m_max = n2;
        this.m_hasMax = bl;
        this.m_regexpr = abstractExpRegularExpression;
    }

    @Nonnull
    public final AbstractExpRegularExpression getRegExpr() {
        return this.m_regexpr;
    }

    public final int getMin() {
        return this.m_min;
    }

    public final boolean hasMax() {
        return this.m_hasMax;
    }

    public final int getMax() {
        return this.m_max;
    }

    @Override
    public Nfa generateNfa(boolean bl) {
        int n;
        ArrayList<AbstractExpRegularExpression> arrayList = new ArrayList<AbstractExpRegularExpression>();
        for (n = 0; n < this.m_min; ++n) {
            arrayList.add(this.m_regexpr);
        }
        if (this.m_hasMax && this.m_max == -1) {
            arrayList.add(new ExpRZeroOrMore(this.m_regexpr));
        }
        while (n++ < this.m_max) {
            arrayList.add(new ExpRZeroOrOne(this.m_regexpr));
        }
        ExpRSequence expRSequence = new ExpRSequence(arrayList);
        return expRSequence.generateNfa(bl);
    }
}

