/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser.exp;

import com.helger.commons.ValueEnforcer;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.Nfa;
import com.helger.pgcc.parser.NfaState;
import com.helger.pgcc.parser.exp.AbstractExpRegularExpression;
import com.helger.pgcc.parser.exp.ExpRCharacterList;
import com.helger.pgcc.parser.exp.ExpRJustName;
import com.helger.pgcc.parser.exp.ExpRStringLiteral;
import com.helger.pgcc.parser.exp.ICCCharacter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ExpRChoice
extends AbstractExpRegularExpression {
    private final List<AbstractExpRegularExpression> m_choices = new ArrayList<AbstractExpRegularExpression>();

    @Nonnull
    public final List<AbstractExpRegularExpression> getChoices() {
        return this.m_choices;
    }

    @Nonnegative
    public final int getChoiceCount() {
        return this.m_choices.size();
    }

    @Nonnull
    public final AbstractExpRegularExpression getChoiceAt(int n) {
        return this.m_choices.get(n);
    }

    public final void addChoice(@Nonnull AbstractExpRegularExpression abstractExpRegularExpression) {
        ValueEnforcer.notNull((Object)abstractExpRegularExpression, (String)"Expansion");
        this.m_choices.add(abstractExpRegularExpression);
    }

    @Override
    public Nfa generateNfa(boolean bl) {
        this.compressCharLists();
        if (this.getChoiceCount() == 1) {
            return this.getChoiceAt(0).generateNfa(bl);
        }
        Nfa nfa = new Nfa();
        NfaState nfaState = nfa.start();
        NfaState nfaState2 = nfa.end();
        for (AbstractExpRegularExpression abstractExpRegularExpression : this.getChoices()) {
            Nfa nfa2 = abstractExpRegularExpression.generateNfa(bl);
            nfaState.addMove(nfa2.start());
            nfa2.end().addMove(nfaState2);
        }
        return nfa;
    }

    void compressCharLists() {
        this.compressChoices();
        ExpRCharacterList expRCharacterList = null;
        for (int i = 0; i < this.getChoiceCount(); ++i) {
            AbstractExpRegularExpression abstractExpRegularExpression = this.getChoiceAt(i);
            while (abstractExpRegularExpression instanceof ExpRJustName) {
                abstractExpRegularExpression = ((ExpRJustName)abstractExpRegularExpression).m_regexpr;
            }
            if (abstractExpRegularExpression instanceof ExpRStringLiteral && ((ExpRStringLiteral)abstractExpRegularExpression).m_image.length() == 1) {
                abstractExpRegularExpression = new ExpRCharacterList(((ExpRStringLiteral)abstractExpRegularExpression).m_image.charAt(0));
                this.getChoices().set(i, abstractExpRegularExpression);
            }
            if (!(abstractExpRegularExpression instanceof ExpRCharacterList)) continue;
            if (((ExpRCharacterList)abstractExpRegularExpression).isNegatedList()) {
                ((ExpRCharacterList)abstractExpRegularExpression).removeNegation();
            }
            List<ICCCharacter> list = ((ExpRCharacterList)abstractExpRegularExpression).getDescriptors();
            if (expRCharacterList == null) {
                expRCharacterList = new ExpRCharacterList();
                abstractExpRegularExpression = expRCharacterList;
                this.getChoices().set(i, abstractExpRegularExpression);
            } else {
                this.getChoices().remove(i--);
            }
            int n = list.size();
            while (n-- > 0) {
                expRCharacterList.addDescriptor(list.get(n));
            }
        }
    }

    void compressChoices() {
        for (int i = 0; i < this.getChoiceCount(); ++i) {
            AbstractExpRegularExpression abstractExpRegularExpression = this.getChoiceAt(i);
            while (abstractExpRegularExpression instanceof ExpRJustName) {
                abstractExpRegularExpression = ((ExpRJustName)abstractExpRegularExpression).m_regexpr;
            }
            if (!(abstractExpRegularExpression instanceof ExpRChoice)) continue;
            this.getChoices().remove(i--);
            int n = ((ExpRChoice)abstractExpRegularExpression).getChoiceCount();
            while (n-- > 0) {
                this.addChoice(((ExpRChoice)abstractExpRegularExpression).getChoiceAt(n));
            }
        }
    }

    public int checkUnmatchability() {
        int n = 0;
        for (AbstractExpRegularExpression abstractExpRegularExpression : this.getChoices()) {
            if (!abstractExpRegularExpression.m_private_rexp && abstractExpRegularExpression.getOrdinal() > 0 && abstractExpRegularExpression.getOrdinal() < this.getOrdinal() && LexGenJava.s_lexStates[abstractExpRegularExpression.getOrdinal()] == LexGenJava.s_lexStates[this.getOrdinal()]) {
                if (this.hasLabel()) {
                    JavaCCErrors.warning(this, "Regular Expression choice : " + abstractExpRegularExpression.getLabel() + " can never be matched as : " + this.getLabel());
                } else {
                    JavaCCErrors.warning(this, "Regular Expression choice : " + abstractExpRegularExpression.getLabel() + " can never be matched as token of kind : " + this.getOrdinal());
                }
            }
            if (abstractExpRegularExpression.m_private_rexp || !(abstractExpRegularExpression instanceof ExpRStringLiteral)) continue;
            ++n;
        }
        return n;
    }
}

