/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.pgcc.jjtree.AbstractCharStream;
import com.helger.pgcc.jjtree.Provider;
import java.io.IOException;

public class JavaCharStream
extends AbstractCharStream {
    protected static final int NEXTCHAR_BUF_SIZE = 4096;
    private char[] m_aNextCharBuf = new char[4096];
    private int nextCharInd = -1;
    private Provider m_aIS;

    @Override
    protected int streamRead(char[] cArray, int n, int n2) throws IOException {
        return this.m_aIS.read(cArray, n, n2);
    }

    @Override
    protected void streamClose() throws IOException {
        this.m_aIS.close();
    }

    @Override
    protected void fillBuff() throws IOException {
        if (this.maxNextCharInd == 4096) {
            this.maxNextCharInd = 0;
            this.nextCharInd = 0;
        }
        try {
            int n = this.streamRead(this.m_aNextCharBuf, this.maxNextCharInd, 4096 - this.maxNextCharInd);
            if (n == -1) {
                this.streamClose();
                throw new IOException();
            }
            this.maxNextCharInd += n;
        }
        catch (IOException iOException) {
            if (this.bufpos != 0) {
                --this.bufpos;
                this.backup(0);
            } else {
                this.internalSetBufLineColumn(this.getLine(), this.getColumn());
            }
            throw iOException;
        }
    }

    private char readByte() throws IOException {
        ++this.nextCharInd;
        if (this.nextCharInd >= this.maxNextCharInd) {
            this.fillBuff();
        }
        return this.m_aNextCharBuf[this.nextCharInd];
    }

    @Override
    public char beginToken() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            this.tokenBegin = this.bufpos;
            return this.buffer[this.bufpos];
        }
        this.tokenBegin = 0;
        this.bufpos = -1;
        return this.readChar();
    }

    @Override
    public char readChar() throws IOException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            ++this.bufpos;
            if (this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        ++this.bufpos;
        if (this.bufpos == this.available) {
            this.internalAdjustBuffSize();
        }
        this.buffer[this.bufpos] = c = this.readByte();
        if (c != '\\') {
            if (this.isTrackLineColumn()) {
                this.internalUpdateLineColumn(c);
            }
            return c;
        }
        if (this.isTrackLineColumn()) {
            this.internalUpdateLineColumn(c);
        }
        int n = 1;
        while (true) {
            ++this.bufpos;
            if (this.bufpos == this.available) {
                this.internalAdjustBuffSize();
            }
            try {
                this.buffer[this.bufpos] = c = this.readByte();
                if (c != '\\') {
                    if (this.isTrackLineColumn()) {
                        this.internalUpdateLineColumn(c);
                    }
                    if (c == 'u' && (n & 1) == 1) {
                        --this.bufpos;
                        if (this.bufpos >= 0) break;
                        this.bufpos = this.bufsize - 1;
                        break;
                    }
                    this.backup(n);
                    return '\\';
                }
            }
            catch (IOException iOException) {
                if (n > 1) {
                    this.backup(n - 1);
                }
                return '\\';
            }
            if (this.isTrackLineColumn()) {
                this.internalUpdateLineColumn(c);
            }
            ++n;
        }
        try {
            while ((c = this.readByte()) == 'u') {
                if (!this.isTrackLineColumn()) continue;
                this.internalUpdateLineColumn(c);
            }
            char c2 = c;
            char c3 = this.readByte();
            char c4 = this.readByte();
            char c5 = this.readByte();
            this.buffer[this.bufpos] = c = (char)(JavaCharStream.hexval(c2) << 12 | JavaCharStream.hexval(c3) << 8 | JavaCharStream.hexval(c4) << 4 | JavaCharStream.hexval(c5));
            if (this.isTrackLineColumn()) {
                this.internalUpdateLineColumn(c2);
                this.internalUpdateLineColumn(c3);
                this.internalUpdateLineColumn(c4);
                this.internalUpdateLineColumn(c5);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Invalid escape character at line " + this.getLine() + " column " + this.getColumn() + ".");
        }
        if (n == 1) {
            return c;
        }
        this.backup(n - 1);
        return '\\';
    }

    public JavaCharStream(Provider provider, int n, int n2, int n3) {
        super(n, n2, n3);
        this.m_aIS = provider;
    }

    public JavaCharStream(Provider provider, int n, int n2) {
        this(provider, n, n2, 4096);
    }

    public JavaCharStream(Provider provider) {
        this(provider, 1, 1, 4096);
    }

    public void reInit(Provider provider) {
        this.reInit(provider, 1, 1, 4096);
    }

    public void reInit(Provider provider, int n, int n2) {
        this.reInit(provider, n, n2, 4096);
    }

    public void reInit(Provider provider, int n, int n2, int n3) {
        this.m_aNextCharBuf = new char[4096];
        this.nextCharInd = -1;
        this.m_aIS = provider;
        super.reInit(n, n2, n3);
    }

    @Override
    public void done() {
        this.m_aNextCharBuf = null;
        super.done();
    }
}

