/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;

public class Insert
extends Transform {
    private final int position;
    private final Class<?>[] types;
    private final Object[] values;

    public Insert(int position, Object ... values) {
        this.position = position;
        this.values = values;
        Class[] types = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            types[i] = values[i].getClass();
        }
        this.types = types;
    }

    public Insert(int position, boolean value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Boolean.TYPE};
    }

    public Insert(int position, byte value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Byte.TYPE};
    }

    public Insert(int position, short value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Short.TYPE};
    }

    public Insert(int position, char value) {
        this.position = position;
        this.values = new Object[]{Character.valueOf(value)};
        this.types = new Class[]{Character.TYPE};
    }

    public Insert(int position, int value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Integer.TYPE};
    }

    public Insert(int position, long value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Long.TYPE};
    }

    public Insert(int position, float value) {
        this.position = position;
        this.values = new Object[]{Float.valueOf(value)};
        this.types = new Class[]{Float.TYPE};
    }

    public Insert(int position, double value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Double.TYPE};
    }

    public Insert(int position, Class<?>[] types, Object ... values) {
        this.position = position;
        this.values = values;
        this.types = types;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return MethodHandles.insertArguments(target, this.position, this.values);
    }

    @Override
    public MethodType down(MethodType type) {
        return type.insertParameterTypes(this.position, this.types);
    }

    @Override
    public String toString() {
        return "insert " + Arrays.toString(this.types()) + " at " + this.position;
    }

    @Override
    public String toJava(MethodType incoming) {
        StringBuilder builder = new StringBuilder("handle = MethodHandles.insertArguments(handle, ");
        builder.append(this.position).append(", ");
        boolean second = false;
        for (int i = 0; i < this.types.length; ++i) {
            if (second) {
                builder.append(", ");
            }
            second = true;
            Insert.buildClassCast(builder, this.types[i]);
            if (this.types[i].isPrimitive()) {
                Insert.buildPrimitiveJava(builder, this.values[i]);
                continue;
            }
            builder.append("value").append(i + 1);
        }
        builder.append(");");
        return builder.toString();
    }

    private Class<?>[] types() {
        Class[] types = new Class[this.values.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.values[i].getClass();
        }
        return types;
    }
}

