/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.extract;

import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.QueryConstants;
import com.hazelcast.sql.impl.QueryException;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public final class QueryPath
implements IdentifiedDataSerializable {
    public static final String KEY = QueryConstants.KEY_ATTRIBUTE_NAME.value();
    public static final String VALUE = QueryConstants.THIS_ATTRIBUTE_NAME.value();
    public static final QueryPath KEY_PATH = new QueryPath(null, true);
    public static final QueryPath VALUE_PATH = new QueryPath(null, false);
    public static final String KEY_PREFIX = KEY + ".";
    public static final String VALUE_PREFIX = VALUE + ".";
    private boolean key;
    private String path;

    public QueryPath() {
    }

    public QueryPath(String path, boolean key) {
        this.path = path;
        this.key = key;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isTopLevel() {
        return this.path == null;
    }

    public static QueryPath create(String originalPath) {
        if (QueryPath.isEmpty(originalPath)) {
            throw QueryPath.badPathException(originalPath);
        }
        if (KEY.equals(originalPath)) {
            return KEY_PATH;
        }
        if (VALUE.equals(originalPath)) {
            return VALUE_PATH;
        }
        if (originalPath.startsWith(KEY_PREFIX)) {
            String path = originalPath.substring(KEY_PREFIX.length());
            if (QueryPath.isEmpty(path)) {
                throw QueryPath.badPathException(originalPath);
            }
            return new QueryPath(path, true);
        }
        if (originalPath.startsWith(VALUE_PREFIX)) {
            String path = originalPath.substring(VALUE_PREFIX.length());
            if (QueryPath.isEmpty(path)) {
                throw QueryPath.badPathException(originalPath);
            }
            return new QueryPath(path, false);
        }
        return new QueryPath(originalPath, false);
    }

    private static boolean isEmpty(String path) {
        return path == null || path.isEmpty();
    }

    private static QueryException badPathException(String path) {
        throw QueryException.error((String)("Field cannot be empty: " + path));
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 86;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.key);
        out.writeString(this.path);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readBoolean();
        this.path = in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryPath path1 = (QueryPath)o;
        if (this.key != path1.key) {
            return false;
        }
        return Objects.equals(this.path, path1.path);
    }

    public int hashCode() {
        int result = this.key ? 1 : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public String toString() {
        return (this.key ? KEY : VALUE) + (String)(this.path != null ? "." + this.path : "");
    }
}

