/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.security.Permission;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public class ExpressionEvalContextImpl
implements ExpressionEvalContext {
    private transient Contexts.MetaSupplierCtx contextRef;
    private transient SqlSecurityContext ssc;
    private final List<Object> arguments;
    private final transient InternalSerializationService serializationService;
    private final transient NodeEngine nodeEngine;

    ExpressionEvalContextImpl(@Nonnull List<Object> arguments, @Nonnull InternalSerializationService serializationService, @Nonnull NodeEngine nodeEngine, @Nullable SqlSecurityContext ssc) {
        this.arguments = Objects.requireNonNull(arguments);
        this.serializationService = Objects.requireNonNull(serializationService);
        this.nodeEngine = Objects.requireNonNull(nodeEngine);
        this.ssc = ssc;
    }

    ExpressionEvalContextImpl(@Nonnull List<Object> arguments, @Nonnull InternalSerializationService serializationService, @Nonnull NodeEngine nodeEngine, @Nonnull Contexts.MetaSupplierCtx context) {
        this.arguments = Objects.requireNonNull(arguments);
        this.serializationService = Objects.requireNonNull(serializationService);
        this.nodeEngine = Objects.requireNonNull(nodeEngine);
        this.contextRef = context;
    }

    @Override
    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    @Override
    public List<Object> getArguments() {
        return this.arguments;
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }

    @Override
    public ExpressionEvalContextImpl withSerializationService(@Nonnull InternalSerializationService newService) {
        if (this.serializationService == newService) {
            return this;
        }
        if (this.contextRef != null) {
            return new ExpressionEvalContextImpl(this.arguments, newService, this.nodeEngine, this.contextRef);
        }
        return new ExpressionEvalContextImpl(this.arguments, newService, this.nodeEngine, this.ssc);
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void checkPermission(Permission permission) {
        if (this.contextRef != null) {
            this.contextRef.checkPermission(permission);
        } else if (this.ssc != null) {
            this.ssc.checkPermission(permission);
        }
    }

    @Override
    @Nullable
    public Subject subject() {
        if (this.contextRef != null) {
            return this.contextRef.subject();
        }
        if (this.ssc != null) {
            return this.ssc.subject();
        }
        return null;
    }
}

