/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.util;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import java.awt.Color;
import java.lang.reflect.Method;

public class TestBuilderProxy {
    private static final String CLASS_FUNCTIONS_UTIL = "com.hazelcast.shaded.org.locationtech.jtstest.function.FunctionsUtil";
    private static Class<?> tbClass;
    private static Method methodShowIndicator;
    private static Method methodShowIndicatorLine;

    private static void init() {
        if (tbClass != null) {
            return;
        }
        try {
            tbClass = TestBuilderProxy.class.getClassLoader().loadClass(CLASS_FUNCTIONS_UTIL);
            methodShowIndicator = tbClass.getMethod("showIndicator", Geometry.class);
            methodShowIndicatorLine = tbClass.getMethod("showIndicator", Geometry.class, Color.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isActive() {
        TestBuilderProxy.init();
        return tbClass != null;
    }

    public static void showIndicator(Geometry geom) {
        TestBuilderProxy.init();
        if (methodShowIndicator == null) {
            return;
        }
        try {
            methodShowIndicator.invoke(null, geom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showIndicator(Geometry geom, Color lineClr) {
        TestBuilderProxy.init();
        if (methodShowIndicatorLine == null) {
            return;
        }
        try {
            methodShowIndicatorLine.invoke(null, geom, lineClr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

