/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm.hull;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPolygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.CoverageUnion;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.polygon.ConstrainedDelaunayTriangulator;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.tri.Tri;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConcaveHullOfPolygons {
    private static final int FRAME_EXPAND_FACTOR = 4;
    private static final int NOT_SPECIFIED = -1;
    private static final int NOT_FOUND = -1;
    private Geometry inputPolygons;
    private double maxEdgeLength = 0.0;
    private double maxEdgeLengthRatio = -1.0;
    private boolean isHolesAllowed = false;
    private boolean isTight = false;
    private GeometryFactory geomFactory;
    private LinearRing[] polygonRings;
    private Set<Tri> hullTris;
    private ArrayDeque<Tri> borderTriQue;
    private Map<Tri, Integer> borderEdgeMap = new HashMap<Tri, Integer>();

    public static Geometry concaveHullByLength(Geometry polygons, double maxLength) {
        return ConcaveHullOfPolygons.concaveHullByLength(polygons, maxLength, false, false);
    }

    public static Geometry concaveHullByLength(Geometry polygons, double maxLength, boolean isTight, boolean isHolesAllowed) {
        ConcaveHullOfPolygons hull = new ConcaveHullOfPolygons(polygons);
        hull.setMaximumEdgeLength(maxLength);
        hull.setHolesAllowed(isHolesAllowed);
        hull.setTight(isTight);
        return hull.getHull();
    }

    public static Geometry concaveHullByLengthRatio(Geometry polygons, double lengthRatio) {
        return ConcaveHullOfPolygons.concaveHullByLengthRatio(polygons, lengthRatio, false, false);
    }

    public static Geometry concaveHullByLengthRatio(Geometry polygons, double lengthRatio, boolean isTight, boolean isHolesAllowed) {
        ConcaveHullOfPolygons hull = new ConcaveHullOfPolygons(polygons);
        hull.setMaximumEdgeLengthRatio(lengthRatio);
        hull.setHolesAllowed(isHolesAllowed);
        hull.setTight(isTight);
        return hull.getHull();
    }

    public static Geometry concaveFillByLength(Geometry polygons, double maxLength) {
        ConcaveHullOfPolygons hull = new ConcaveHullOfPolygons(polygons);
        hull.setMaximumEdgeLength(maxLength);
        return hull.getFill();
    }

    public static Geometry concaveFillByLengthRatio(Geometry polygons, double lengthRatio) {
        ConcaveHullOfPolygons hull = new ConcaveHullOfPolygons(polygons);
        hull.setMaximumEdgeLengthRatio(lengthRatio);
        return hull.getFill();
    }

    public ConcaveHullOfPolygons(Geometry polygons) {
        if (!(polygons instanceof Polygon) && !(polygons instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Input must be polygonal");
        }
        this.inputPolygons = polygons;
        this.geomFactory = this.inputPolygons.getFactory();
    }

    public void setMaximumEdgeLength(double edgeLength) {
        if (edgeLength < 0.0) {
            throw new IllegalArgumentException("Edge length must be non-negative");
        }
        this.maxEdgeLength = edgeLength;
        this.maxEdgeLengthRatio = -1.0;
    }

    public void setMaximumEdgeLengthRatio(double edgeLengthRatio) {
        if (edgeLengthRatio < 0.0 || edgeLengthRatio > 1.0) {
            throw new IllegalArgumentException("Edge length ratio must be in range [0,1]");
        }
        this.maxEdgeLengthRatio = edgeLengthRatio;
    }

    public void setHolesAllowed(boolean isHolesAllowed) {
        this.isHolesAllowed = isHolesAllowed;
    }

    public void setTight(boolean isTight) {
        this.isTight = isTight;
    }

    public Geometry getHull() {
        if (this.inputPolygons.isEmpty()) {
            return this.createEmptyHull();
        }
        this.buildHullTris();
        Geometry hull = this.createHullGeometry(this.hullTris, true);
        return hull;
    }

    public Geometry getFill() {
        this.isTight = true;
        if (this.inputPolygons.isEmpty()) {
            return this.createEmptyHull();
        }
        this.buildHullTris();
        Geometry fill = this.createHullGeometry(this.hullTris, false);
        return fill;
    }

    private Geometry createEmptyHull() {
        return this.geomFactory.createPolygon();
    }

    private void buildHullTris() {
        this.polygonRings = ConcaveHullOfPolygons.extractShellRings(this.inputPolygons);
        Polygon frame = ConcaveHullOfPolygons.createFrame(this.inputPolygons.getEnvelopeInternal(), this.polygonRings, this.geomFactory);
        ConstrainedDelaunayTriangulator cdt = new ConstrainedDelaunayTriangulator(frame);
        List<Tri> tris = cdt.getTriangles();
        Coordinate[] framePts = frame.getExteriorRing().getCoordinates();
        if (this.maxEdgeLengthRatio >= 0.0) {
            this.maxEdgeLength = ConcaveHullOfPolygons.computeTargetEdgeLength(tris, framePts, this.maxEdgeLengthRatio);
        }
        this.hullTris = this.removeFrameCornerTris(tris, framePts);
        this.removeBorderTris();
        if (this.isHolesAllowed) {
            this.removeHoleTris();
        }
    }

    private static double computeTargetEdgeLength(List<Tri> triList, Coordinate[] frameCorners, double edgeLengthRatio) {
        if (edgeLengthRatio == 0.0) {
            return 0.0;
        }
        double maxEdgeLen = -1.0;
        double minEdgeLen = -1.0;
        for (Tri tri : triList) {
            if (ConcaveHullOfPolygons.isFrameTri(tri, frameCorners)) continue;
            for (int i = 0; i < 3; ++i) {
                if (!tri.hasAdjacent(i)) continue;
                double len = tri.getLength(i);
                if (len > maxEdgeLen) {
                    maxEdgeLen = len;
                }
                if (!(minEdgeLen < 0.0) && !(len < minEdgeLen)) continue;
                minEdgeLen = len;
            }
        }
        if (edgeLengthRatio == 1.0) {
            return 2.0 * maxEdgeLen;
        }
        return edgeLengthRatio * (maxEdgeLen - minEdgeLen) + minEdgeLen;
    }

    private static boolean isFrameTri(Tri tri, Coordinate[] frameCorners) {
        int index = ConcaveHullOfPolygons.vertexIndex(tri, frameCorners);
        boolean isFrameTri = index >= 0;
        return isFrameTri;
    }

    private Set<Tri> removeFrameCornerTris(List<Tri> tris, Coordinate[] frameCorners) {
        HashSet<Tri> hullTris = new HashSet<Tri>();
        this.borderTriQue = new ArrayDeque();
        for (Tri tri : tris) {
            boolean isFrameTri;
            int index = ConcaveHullOfPolygons.vertexIndex(tri, frameCorners);
            boolean bl = isFrameTri = index != -1;
            if (isFrameTri) {
                boolean isBorderTri;
                int oppIndex = Tri.oppEdge(index);
                Tri oppTri = tri.getAdjacent(oppIndex);
                boolean bl2 = isBorderTri = oppTri != null && !ConcaveHullOfPolygons.isFrameTri(oppTri, frameCorners);
                if (isBorderTri) {
                    this.addBorderTri(tri, oppIndex);
                }
                tri.remove();
                continue;
            }
            hullTris.add(tri);
        }
        return hullTris;
    }

    private static int vertexIndex(Tri tri, Coordinate[] pts) {
        for (Coordinate p : pts) {
            int index = tri.getIndex(p);
            if (index < 0) continue;
            return index;
        }
        return -1;
    }

    private void removeBorderTris() {
        while (!this.borderTriQue.isEmpty()) {
            Tri tri = this.borderTriQue.pop();
            if (!this.hullTris.contains(tri) || !this.isRemovable(tri)) continue;
            this.addBorderTris(tri);
            this.removeBorderTri(tri);
        }
    }

    private void removeHoleTris() {
        Tri holeTri;
        while ((holeTri = this.findHoleSeedTri(this.hullTris)) != null) {
            this.addBorderTris(holeTri);
            this.removeBorderTri(holeTri);
            this.removeBorderTris();
        }
        return;
    }

    private Tri findHoleSeedTri(Set<Tri> tris) {
        for (Tri tri : tris) {
            if (!this.isHoleSeedTri(tri)) continue;
            return tri;
        }
        return null;
    }

    private boolean isHoleSeedTri(Tri tri) {
        if (this.isBorderTri(tri)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (!tri.hasAdjacent(i) || !(tri.getLength(i) > this.maxEdgeLength)) continue;
            return true;
        }
        return false;
    }

    private boolean isBorderTri(Tri tri) {
        for (int i = 0; i < 3; ++i) {
            if (tri.hasAdjacent(i)) continue;
            return true;
        }
        return false;
    }

    private boolean isRemovable(Tri tri) {
        int borderEdgeIndex;
        double edgeLen;
        if (this.isTight && this.isTouchingSinglePolygon(tri)) {
            return true;
        }
        return this.borderEdgeMap.containsKey(tri) && (edgeLen = tri.getLength(borderEdgeIndex = this.borderEdgeMap.get(tri).intValue())) > this.maxEdgeLength;
    }

    private boolean isTouchingSinglePolygon(Tri tri) {
        Envelope envTri = ConcaveHullOfPolygons.envelope(tri);
        for (LinearRing ring : this.polygonRings) {
            if (!ring.getEnvelopeInternal().intersects(envTri) || !ConcaveHullOfPolygons.hasAllVertices(ring, tri)) continue;
            return true;
        }
        return false;
    }

    private void addBorderTris(Tri tri) {
        this.addBorderTri(tri, 0);
        this.addBorderTri(tri, 1);
        this.addBorderTri(tri, 2);
    }

    private void addBorderTri(Tri tri, int index) {
        Tri adj = tri.getAdjacent(index);
        if (adj == null) {
            return;
        }
        this.borderTriQue.add(adj);
        int borderEdgeIndex = adj.getIndex(tri);
        this.borderEdgeMap.put(adj, borderEdgeIndex);
    }

    private void removeBorderTri(Tri tri) {
        tri.remove();
        this.hullTris.remove(tri);
        this.borderEdgeMap.remove(tri);
    }

    private static boolean hasAllVertices(LinearRing ring, Tri tri) {
        for (int i = 0; i < 3; ++i) {
            Coordinate v = tri.getCoordinate(i);
            if (ConcaveHullOfPolygons.hasVertex(ring, v)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasVertex(LinearRing ring, Coordinate v) {
        for (int i = 1; i < ring.getNumPoints(); ++i) {
            if (!v.equals2D(ring.getCoordinateN(i))) continue;
            return true;
        }
        return false;
    }

    private static Envelope envelope(Tri tri) {
        Envelope env = new Envelope(tri.getCoordinate(0), tri.getCoordinate(1));
        env.expandToInclude(tri.getCoordinate(2));
        return env;
    }

    private Geometry createHullGeometry(Set<Tri> hullTris, boolean isIncludeInput) {
        if (!isIncludeInput && hullTris.isEmpty()) {
            return this.createEmptyHull();
        }
        Geometry triCoverage = Tri.toGeometry(hullTris, this.geomFactory);
        Geometry fillGeometry = CoverageUnion.union(triCoverage);
        if (!isIncludeInput) {
            return fillGeometry;
        }
        if (fillGeometry.isEmpty()) {
            return this.inputPolygons.copy();
        }
        Geometry[] geoms = new Geometry[]{fillGeometry, this.inputPolygons};
        GeometryCollection geomColl = this.geomFactory.createGeometryCollection(geoms);
        Geometry hull = CoverageUnion.union(geomColl);
        return hull;
    }

    private static Polygon createFrame(Envelope polygonsEnv, LinearRing[] polygonRings, GeometryFactory geomFactory) {
        double diam = polygonsEnv.getDiameter();
        Envelope envFrame = polygonsEnv.copy();
        envFrame.expandBy(4.0 * diam);
        Polygon frameOuter = (Polygon)geomFactory.toGeometry(envFrame);
        LinearRing shell = (LinearRing)frameOuter.getExteriorRing().copy();
        Polygon frame = geomFactory.createPolygon(shell, polygonRings);
        return frame;
    }

    private static LinearRing[] extractShellRings(Geometry polygons) {
        LinearRing[] rings = new LinearRing[polygons.getNumGeometries()];
        for (int i = 0; i < polygons.getNumGeometries(); ++i) {
            Polygon consPoly = (Polygon)polygons.getGeometryN(i);
            rings[i] = (LinearRing)consPoly.getExteriorRing().copy();
        }
        return rings;
    }
}

