/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm.distance;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.distance.PointPairDistance;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import java.util.Arrays;
import java.util.HashMap;

public class DiscreteFrechetDistance {
    private final Geometry g0;
    private final Geometry g1;
    private PointPairDistance ptDist;

    public static double distance(Geometry g0, Geometry g1) {
        DiscreteFrechetDistance dist = new DiscreteFrechetDistance(g0, g1);
        return dist.distance();
    }

    public DiscreteFrechetDistance(Geometry g0, Geometry g1) {
        this.g0 = g0;
        this.g1 = g1;
    }

    private double distance() {
        Coordinate[] coords0 = this.g0.getCoordinates();
        Coordinate[] coords1 = this.g1.getCoordinates();
        MatrixStorage distances = DiscreteFrechetDistance.createMatrixStorage(coords0.length, coords1.length);
        int[] diagonal = DiscreteFrechetDistance.bresenhamDiagonal(coords0.length, coords1.length);
        HashMap<Double, int[]> distanceToPair = new HashMap<Double, int[]>();
        this.computeCoordinateDistances(coords0, coords1, diagonal, distances, distanceToPair);
        this.ptDist = DiscreteFrechetDistance.computeFrechet(coords0, coords1, diagonal, distances, distanceToPair);
        return this.ptDist.getDistance();
    }

    private static MatrixStorage createMatrixStorage(int rows, int cols) {
        int max = Math.max(rows, cols);
        if (max < 1024) {
            return new RectMatrix(rows, cols, Double.POSITIVE_INFINITY);
        }
        return new CsrMatrix(rows, cols, Double.POSITIVE_INFINITY);
    }

    public Coordinate[] getCoordinates() {
        if (this.ptDist == null) {
            this.distance();
        }
        return this.ptDist.getCoordinates();
    }

    private static PointPairDistance computeFrechet(Coordinate[] coords0, Coordinate[] coords1, int[] diagonal, MatrixStorage distances, HashMap<Double, int[]> distanceToPair) {
        for (int d = 0; d < diagonal.length; d += 2) {
            double dist;
            int i0 = diagonal[d];
            int j0 = diagonal[d + 1];
            for (int i = i0; i < coords0.length && distances.isValueSet(i, j0); ++i) {
                dist = DiscreteFrechetDistance.getMinDistanceAtCorner(distances, i, j0);
                if (!(dist > distances.get(i, j0))) continue;
                distances.set(i, j0, dist);
            }
            for (int j = j0 + 1; j < coords1.length && distances.isValueSet(i0, j); ++j) {
                dist = DiscreteFrechetDistance.getMinDistanceAtCorner(distances, i0, j);
                if (!(dist > distances.get(i0, j))) continue;
                distances.set(i0, j, dist);
            }
        }
        PointPairDistance result = new PointPairDistance();
        double distance = distances.get(coords0.length - 1, coords1.length - 1);
        int[] index = distanceToPair.get(distance);
        if (index == null) {
            throw new IllegalStateException("Pair of points not recorded for computed distance");
        }
        result.initialize(coords0[index[0]], coords1[index[1]], distance);
        return result;
    }

    private static double getMinDistanceAtCorner(MatrixStorage matrix, int i, int j) {
        if (i > 0 && j > 0) {
            double d0 = matrix.get(i - 1, j - 1);
            double d1 = matrix.get(i - 1, j);
            double d2 = matrix.get(i, j - 1);
            return Math.min(Math.min(d0, d1), d2);
        }
        if (i == 0 && j == 0) {
            return matrix.get(0, 0);
        }
        if (i == 0) {
            return matrix.get(0, j - 1);
        }
        return matrix.get(i - 1, 0);
    }

    private void computeCoordinateDistances(Coordinate[] coords0, Coordinate[] coords1, int[] diagonal, MatrixStorage distances, HashMap<Double, int[]> distanceToPair) {
        int j0;
        int i0;
        int k;
        int numDiag = diagonal.length;
        double maxDistOnDiag = 0.0;
        int imin = 0;
        int jmin = 0;
        int numCoords0 = coords0.length;
        int numCoords1 = coords1.length;
        for (k = 0; k < numDiag; k += 2) {
            i0 = diagonal[k];
            j0 = diagonal[k + 1];
            double diagDist = coords0[i0].distance(coords1[j0]);
            if (diagDist > maxDistOnDiag) {
                maxDistOnDiag = diagDist;
            }
            distances.set(i0, j0, diagDist);
            distanceToPair.putIfAbsent(diagDist, new int[]{i0, j0});
        }
        for (k = 0; k < numDiag - 2; k += 2) {
            double dist;
            double dist2;
            i0 = diagonal[k];
            j0 = diagonal[k + 1];
            Coordinate coord0 = coords0[i0];
            Coordinate coord1 = coords1[j0];
            int i = i0 + 1;
            while (i < numCoords0 && !distances.isValueSet(i, j0) && ((dist2 = coords0[i].distance(coord1)) < maxDistOnDiag || i < imin)) {
                distances.set(i, j0, dist2);
                distanceToPair.putIfAbsent(dist2, new int[]{i++, j0});
            }
            imin = i;
            int j = j0 + 1;
            while (j < numCoords1 && !distances.isValueSet(i0, j) && ((dist = coord0.distance(coords1[j])) < maxDistOnDiag || j < jmin)) {
                distances.set(i0, j, dist);
                distanceToPair.putIfAbsent(dist, new int[]{i0, j++});
            }
            jmin = j;
        }
    }

    static int[] bresenhamDiagonal(int numCols, int numRows) {
        int dim = Math.max(numCols, numRows);
        int[] diagXY = new int[2 * dim];
        int dx = numCols - 1;
        int dy = numRows - 1;
        int i = 0;
        if (numCols > numRows) {
            int y = 0;
            int err = 2 * dy - dx;
            for (int x = 0; x < numCols; ++x) {
                diagXY[i++] = x;
                diagXY[i++] = y++;
                if (err > 0) {
                    err -= 2 * dx;
                }
                err += 2 * dy;
            }
        } else {
            int x = 0;
            int err = 2 * dx - dy;
            for (int y = 0; y < numRows; ++y) {
                diagXY[i++] = x++;
                diagXY[i++] = y;
                if (err > 0) {
                    err -= 2 * dy;
                }
                err += 2 * dx;
            }
        }
        return diagXY;
    }

    static final class HashMapMatrix
    extends MatrixStorage {
        private final HashMap<Long, Double> matrix = new HashMap();

        public HashMapMatrix(int numRows, int numCols, double defaultValue) {
            super(numRows, numCols, defaultValue);
        }

        @Override
        public double get(int i, int j) {
            long key = (long)i << 32 | (long)j;
            return this.matrix.getOrDefault(key, this.defaultValue);
        }

        @Override
        public void set(int i, int j, double value) {
            long key = (long)i << 32 | (long)j;
            this.matrix.put(key, value);
        }

        @Override
        public boolean isValueSet(int i, int j) {
            long key = (long)i << 32 | (long)j;
            return this.matrix.containsKey(key);
        }
    }

    static final class CsrMatrix
    extends MatrixStorage {
        private double[] v;
        private final int[] ri;
        private int[] ci;

        public CsrMatrix(int numRows, int numCols, double defaultValue) {
            this(numRows, numCols, defaultValue, CsrMatrix.expectedValuesHeuristic(numRows, numCols));
        }

        public CsrMatrix(int numRows, int numCols, double defaultValue, int expectedValues) {
            super(numRows, numCols, defaultValue);
            this.v = new double[expectedValues];
            this.ci = new int[expectedValues];
            this.ri = new int[numRows + 1];
        }

        private static int expectedValuesHeuristic(int numRows, int numCols) {
            int max = Math.max(numRows, numCols);
            return max * max / 10;
        }

        private int indexOf(int i, int j) {
            int cHigh = this.ri[i + 1];
            int cLow = this.ri[i];
            if (cHigh <= cLow) {
                return ~cLow;
            }
            return Arrays.binarySearch(this.ci, cLow, cHigh, j);
        }

        @Override
        public double get(int i, int j) {
            int vi = this.indexOf(i, j);
            if (vi < 0) {
                return this.defaultValue;
            }
            return this.v[vi];
        }

        @Override
        public void set(int i, int j, double value) {
            int vi = this.indexOf(i, j);
            if (vi < 0) {
                this.ensureCapacity(this.ri[this.numRows] + 1);
                int ii = i + 1;
                while (ii <= this.numRows) {
                    int n = ii++;
                    this.ri[n] = this.ri[n] + 1;
                }
                vi ^= 0xFFFFFFFF;
                for (ii = this.ri[this.numRows]; ii > vi; --ii) {
                    this.ci[ii] = this.ci[ii - 1];
                    this.v[ii] = this.v[ii - 1];
                }
                this.ci[vi] = j;
            }
            this.v[vi] = value;
        }

        @Override
        public boolean isValueSet(int i, int j) {
            return this.indexOf(i, j) >= 0;
        }

        private void ensureCapacity(int required) {
            if (required < this.v.length) {
                return;
            }
            int increment = Math.max(this.numRows, this.numCols);
            this.v = Arrays.copyOf(this.v, this.v.length + increment);
            this.ci = Arrays.copyOf(this.ci, this.v.length + increment);
        }
    }

    static final class RectMatrix
    extends MatrixStorage {
        private final double[] matrix;

        public RectMatrix(int numRows, int numCols, double defaultValue) {
            super(numRows, numCols, defaultValue);
            this.matrix = new double[numRows * numCols];
            Arrays.fill(this.matrix, defaultValue);
        }

        @Override
        public double get(int i, int j) {
            return this.matrix[i * this.numCols + j];
        }

        @Override
        public void set(int i, int j, double value) {
            this.matrix[i * this.numCols + j] = value;
        }

        @Override
        public boolean isValueSet(int i, int j) {
            return Double.doubleToLongBits(this.get(i, j)) != Double.doubleToLongBits(this.defaultValue);
        }
    }

    static abstract class MatrixStorage {
        protected final int numRows;
        protected final int numCols;
        protected final double defaultValue;

        public MatrixStorage(int numRows, int numCols, double defaultValue) {
            this.numRows = numRows;
            this.numCols = numCols;
            this.defaultValue = defaultValue;
        }

        public abstract double get(int var1, int var2);

        public abstract void set(int var1, int var2, double var3);

        public abstract boolean isValueSet(int var1, int var2);
    }
}

