/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.integration;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.TrapezoidIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;

public class SimpsonIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int SIMPSON_MAX_ITERATIONS_COUNT = 64;

    public SimpsonIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws NotStrictlyPositiveException, NumberIsTooSmallException, NumberIsTooLargeException {
        super(relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new NumberIsTooLargeException(maximalIterationCount, (Number)64, false);
        }
    }

    public SimpsonIntegrator(int minimalIterationCount, int maximalIterationCount) throws NotStrictlyPositiveException, NumberIsTooSmallException, NumberIsTooLargeException {
        super(minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new NumberIsTooLargeException(maximalIterationCount, (Number)64, false);
        }
    }

    public SimpsonIntegrator() {
        super(3, 64);
    }

    protected double doIntegrate() throws TooManyEvaluationsException, MaxCountExceededException {
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        if (this.getMinimalIterationCount() == 1) {
            return (4.0 * qtrap.stage(this, 1) - qtrap.stage(this, 0)) / 3.0;
        }
        double olds = 0.0;
        double oldt = qtrap.stage(this, 0);
        while (true) {
            double rLimit;
            double delta;
            double t2 = qtrap.stage(this, this.getIterations());
            this.incrementCount();
            double s2 = (4.0 * t2 - oldt) / 3.0;
            if (this.getIterations() >= this.getMinimalIterationCount() && ((delta = FastMath.abs(s2 - olds)) <= (rLimit = this.getRelativeAccuracy() * (FastMath.abs(olds) + FastMath.abs(s2)) * 0.5) || delta <= this.getAbsoluteAccuracy())) {
                return s2;
            }
            olds = s2;
            oldt = t2;
        }
    }
}

