/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeTransforms;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Locale;

public class SqlJsonModifyFunction
extends SqlFunction {
    public SqlJsonModifyFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.VARCHAR_2000, SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.ANY, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(3);
    }

    @Override
    protected void checkOperandCount(SqlValidator validator, @Nullable SqlOperandTypeChecker argType, SqlCall call) {
        assert (call.operandCount() >= 3 && call.operandCount() % 2 == 1);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int count = callBinding.getOperandCount();
        for (int i = 1; i < count; i += 2) {
            RelDataType nameType = callBinding.getOperandType(i);
            if (!SqlTypeUtil.isCharacter(nameType)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.expectedCharacter());
                }
                return false;
            }
            if (!nameType.isNullable()) continue;
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustNotBeNull(callBinding.operand(i).toString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount % 2 == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("{0}(");
        for (int i = 1; i < operandsCount; ++i) {
            sb.append(String.format(Locale.ROOT, "{%d} ", i + 1));
        }
        sb.append("{1})");
        return sb.toString();
    }
}

