/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.ddl;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlTruncate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.List;

public class SqlTruncateTable
extends SqlTruncate {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("TRUNCATE TABLE", SqlKind.TRUNCATE_TABLE);
    public final SqlIdentifier name;
    public final boolean continueIdentify;

    public SqlTruncateTable(SqlParserPos pos, SqlIdentifier name, boolean continueIdentify) {
        super(OPERATOR, pos);
        this.name = name;
        this.continueIdentify = continueIdentify;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("TRUNCATE");
        writer.keyword("TABLE");
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.continueIdentify) {
            writer.keyword("CONTINUE IDENTITY");
        } else {
            writer.keyword("RESTART IDENTITY");
        }
    }
}

