/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.runtime;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.com.google.common.collect.Lists;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Functions;
import com.hazelcast.shaded.org.apache.calcite.runtime.MapEntry;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public class PairList<T, U>
extends AbstractList<Map.Entry<T, U>> {
    final List<@Nullable Object> list;

    private PairList(List<@Nullable Object> list) {
        this.list = list;
    }

    public static <T, U> PairList<T, U> of() {
        return new PairList<T, U>(new ArrayList<Object>());
    }

    public static <T, U> PairList<T, U> of(T t2, U u) {
        ArrayList<@Nullable Object> list = new ArrayList<Object>();
        list.add(t2);
        list.add(u);
        return new PairList<T, U>(list);
    }

    public static <T, U> PairList<T, U> copyOf(T t2, U u, Object ... rest) {
        Preconditions.checkArgument(rest.length % 2 == 0, "even number");
        return new PairList<T, U>(new ArrayList<Object>(Lists.asList(t2, u, rest)));
    }

    public static <T, U> PairList<T, U> withCapacity(int initialCapacity) {
        return PairList.backedBy(new ArrayList<Object>(initialCapacity));
    }

    public static <T, U> PairList<T, U> backedBy(List<@Nullable Object> list) {
        return new PairList<T, U>(list);
    }

    public static <T, U> PairList<T, U> of(Map<T, U> map) {
        ArrayList<@Nullable Object> list = new ArrayList<Object>(map.size() * 2);
        map.forEach((? super K t2, ? super V u) -> {
            list.add(t2);
            list.add(u);
        });
        return new PairList<T, U>(list);
    }

    public static <T, U> Builder<T, U> builder() {
        return new Builder();
    }

    @Override
    public Map.Entry<T, U> get(int index) {
        int x = index * 2;
        return new MapEntry<Object, Object>(this.list.get(x), this.list.get(x + 1));
    }

    @Override
    public int size() {
        return this.list.size() / 2;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean add(Map.Entry<T, U> entry) {
        this.list.add(entry.getKey());
        this.list.add(entry.getValue());
        return true;
    }

    @Override
    public void add(int index, Map.Entry<T, U> entry) {
        int x = index * 2;
        this.list.add(x, entry.getKey());
        this.list.add(x + 1, entry.getValue());
    }

    public void add(T t2, U u) {
        this.list.add(t2);
        this.list.add(u);
    }

    public void add(int index, T t2, U u) {
        int x = index * 2;
        this.list.add(x, t2);
        this.list.add(x + 1, u);
    }

    public boolean addAll(PairList<T, U> list2) {
        return this.list.addAll(list2.list);
    }

    public boolean addAll(int index, PairList<T, U> list2) {
        int x = index * 2;
        return this.list.addAll(x, list2.list);
    }

    @Override
    public Map.Entry<T, U> set(int index, Map.Entry<T, U> entry) {
        return this.set(index, entry.getKey(), entry.getValue());
    }

    public Map.Entry<T, U> set(int index, T t2, U u) {
        int x = index * 2;
        Object t0 = this.list.set(x, t2);
        Object u0 = this.list.set(x + 1, u);
        return new MapEntry<Object, Object>(t0, u0);
    }

    @Override
    public Map.Entry<T, U> remove(int index) {
        int x = index * 2;
        Object t2 = this.list.remove(x);
        Object u = this.list.remove(x);
        return new MapEntry<Object, Object>(t2, u);
    }

    public List<T> leftList() {
        final int size = this.list.size() / 2;
        return new RandomAccessList<T>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public T get(int index) {
                return PairList.this.list.get(index * 2);
            }
        };
    }

    public List<U> rightList() {
        final int size = this.list.size() / 2;
        return new RandomAccessList<U>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public U get(int index) {
                return PairList.this.list.get(index * 2 + 1);
            }
        };
    }

    public void forEach(BiConsumer<T, U> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        int i = 0;
        while (i < this.list.size()) {
            Object t2 = this.list.get(i++);
            Object u = this.list.get(i++);
            consumer.accept(t2, u);
        }
    }

    public void forEachIndexed(IndexedBiConsumer<T, U> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        int i = 0;
        int j = 0;
        while (i < this.list.size()) {
            Object t2 = this.list.get(i++);
            Object u = this.list.get(i++);
            consumer.accept(j++, t2, u);
        }
    }

    public ImmutableMap<T, U> toImmutableMap() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.forEach((T t2, U u) -> b.put(t2, u));
        return b.build();
    }

    public PairList<T, U> immutable() {
        ImmutableList<@Nullable Object> immutableList = ImmutableList.copyOf(this.list);
        return PairList.backedBy(immutableList);
    }

    public <R> List<R> transform(BiFunction<T, U, R> function) {
        return Functions.generate(this.list.size() / 2, index -> {
            int x = index * 2;
            Object t2 = this.list.get(x);
            Object u = this.list.get(x + 1);
            return function.apply(t2, u);
        });
    }

    public boolean anyMatch(BiPredicate<T, U> predicate) {
        int i = 0;
        while (i < this.list.size()) {
            Object u;
            Object t2;
            if (!predicate.test(t2 = this.list.get(i++), u = this.list.get(i++))) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(BiPredicate<T, U> predicate) {
        int i = 0;
        while (i < this.list.size()) {
            Object u;
            Object t2;
            if (predicate.test(t2 = this.list.get(i++), u = this.list.get(i++))) continue;
            return false;
        }
        return true;
    }

    public boolean noMatch(BiPredicate<T, U> predicate) {
        int i = 0;
        while (i < this.list.size()) {
            Object u;
            Object t2;
            if (!predicate.test(t2 = this.list.get(i++), u = this.list.get(i++))) continue;
            return false;
        }
        return true;
    }

    private static abstract class RandomAccessList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private RandomAccessList() {
        }
    }

    public static class Builder<T, U> {
        final List<@Nullable Object> list = new ArrayList<Object>();

        public Builder<T, U> add(T t2, U u) {
            this.list.add(t2);
            this.list.add(u);
            return this;
        }

        public PairList<T, U> build() {
            return new PairList(this.list);
        }
    }

    public static interface IndexedBiConsumer<T, U> {
        public void accept(int var1, T var2, U var3);
    }
}

