/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.linq4j.tree;

import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.BlockStatement;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.MemberDeclaration;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;

public class MethodDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final String name;
    public final Type resultType;
    public final List<ParameterExpression> parameters;
    public final BlockStatement body;

    public MethodDeclaration(int modifier, String name, Type resultType, List<ParameterExpression> parameters, BlockStatement body) {
        assert (name != null) : "name should not be null";
        assert (resultType != null) : "resultType should not be null";
        assert (parameters != null) : "parameters should not be null";
        assert (body != null) : "body should not be null";
        this.modifier = modifier;
        this.name = name;
        this.resultType = resultType;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    public MemberDeclaration accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        BlockStatement body = this.body.accept(shuttle);
        return shuttle.visit(this, body);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.resultType).append(' ').append(this.name).list("(", ", ", ")", () -> this.parameters.stream().map(ParameterExpression::declString).iterator()).append(' ').append(this.body);
        writer.newlineAndIndent();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDeclaration that = (MethodDeclaration)o;
        if (this.modifier != that.modifier) {
            return false;
        }
        if (!this.body.equals(that.body)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.resultType.equals(that.resultType);
    }

    public int hashCode() {
        return Objects.hash(this.modifier, this.name, this.resultType, this.parameters, this.body);
    }
}

