/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.enumerable;

import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumUtils;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.NotNullImplementor;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.MethodCallExpression;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectiveCallNotNullImplementor
implements NotNullImplementor {
    protected final Method method;

    public ReflectiveCallNotNullImplementor(Method method) {
        this.method = method;
    }

    @Override
    public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
        MethodCallExpression callExpr;
        translatedOperands = EnumUtils.fromInternal(this.method.getParameterTypes(), translatedOperands);
        translatedOperands = EnumUtils.convertAssignableTypes(this.method.getParameterTypes(), translatedOperands);
        if ((this.method.getModifiers() & 8) != 0) {
            callExpr = Expressions.call(this.method, translatedOperands);
        } else {
            Expression target = translator.functionInstance(call, this.method);
            callExpr = Expressions.call(target, this.method, translatedOperands);
        }
        if (!ReflectiveCallNotNullImplementor.containsCheckedException(this.method)) {
            return callExpr;
        }
        return translator.handleMethodCheckedExceptions(callExpr);
    }

    private static boolean containsCheckedException(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions == null || exceptions.length == 0) {
            return false;
        }
        for (Class<?> clazz : exceptions) {
            if (RuntimeException.class.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

