/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.enumerable;

import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableWindow;
import com.hazelcast.shaded.org.apache.calcite.plan.Convention;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Window;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalWindow;

class EnumerableWindowRule
extends ConverterRule {
    static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalWindow.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableWindowRule").withRuleFactory(EnumerableWindowRule::new);

    protected EnumerableWindowRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public RelNode convert(RelNode rel) {
        Window winAgg = (Window)rel;
        RelTraitSet traitSet = winAgg.getTraitSet().replace(EnumerableConvention.INSTANCE);
        RelNode child = winAgg.getInput();
        RelNode convertedChild = EnumerableWindowRule.convert(child, child.getTraitSet().replace(EnumerableConvention.INSTANCE));
        return new EnumerableWindow(rel.getCluster(), traitSet, convertedChild, winAgg.getConstants(), winAgg.getRowType(), winAgg.groups);
    }
}

