/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.jayway.jsonpath.internal.function;

import com.hazelcast.shaded.com.jayway.jsonpath.InvalidPathException;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.PathFunction;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.json.Append;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.json.KeySetFunction;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.numeric.Average;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.numeric.Max;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.numeric.Min;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.numeric.StandardDeviation;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.numeric.Sum;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.text.Concatenate;
import com.hazelcast.shaded.com.jayway.jsonpath.internal.function.text.Length;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PathFunctionFactory {
    public static final Map<String, Class> FUNCTIONS;

    public static PathFunction newFunction(String name) throws InvalidPathException {
        Class functionClazz = FUNCTIONS.get(name);
        if (functionClazz == null) {
            throw new InvalidPathException("Function with name: " + name + " does not exist.");
        }
        try {
            return (PathFunction)functionClazz.newInstance();
        }
        catch (Exception e) {
            throw new InvalidPathException("Function of name: " + name + " cannot be created", e);
        }
    }

    static {
        HashMap<String, Class<KeySetFunction>> map = new HashMap<String, Class<KeySetFunction>>();
        map.put("avg", Average.class);
        map.put("stddev", StandardDeviation.class);
        map.put("sum", Sum.class);
        map.put("min", Min.class);
        map.put("max", Max.class);
        map.put("concat", Concatenate.class);
        map.put("length", Length.class);
        map.put("size", Length.class);
        map.put("append", Append.class);
        map.put("keys", KeySetFunction.class);
        FUNCTIONS = Collections.unmodifiableMap(map);
    }
}

