/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlDataType;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.SqlTypeColumn;
import com.hazelcast.jet.sql.impl.parse.UnparseUtil;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.sql.impl.schema.type.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class SqlCreateType
extends SqlCreate {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE TYPE", SqlKind.CREATE_TYPE);
    private final SqlIdentifier name;
    private final SqlNodeList columns;
    private final SqlNodeList options;

    public SqlCreateType(SqlIdentifier name, SqlNodeList columns, SqlNodeList options, boolean replace, boolean ifNotExists, SqlParserPos pos) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.columns = Objects.requireNonNull(columns, "Columns should not be null");
        this.options = Objects.requireNonNull(options, "Options should not be null");
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columns, this.options);
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace() && this.ifNotExists) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.orReplaceWithIfNotExistsNotSupported());
        }
        if (!ValidationUtil.isCatalogObjectNameValid(this.name)) {
            throw validator.newValidationError(this.name, ParserResource.RESOURCE.typeIncorrectSchema());
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (SqlNode column : this.columns.getList()) {
            String name = ((SqlTypeColumn)column).name();
            if (columnNames.add(name)) continue;
            throw validator.newValidationError(column, ParserResource.RESOURCE.duplicateColumn(name));
        }
        HashSet<String> optionNames = new HashSet<String>();
        for (SqlNode option : this.options.getList()) {
            String name = ((SqlOption)option).keyString();
            if (optionNames.add(name)) continue;
            throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(name));
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("TYPE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (!this.columns.isEmpty()) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode column : this.columns) {
                UnparseUtil.printIndent(writer);
                column.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(frame);
        }
        UnparseUtil.unparseOptions(writer, this.options);
    }

    public static String unparse(Type type) {
        SqlPrettyWriter writer = new SqlPrettyWriter(SqlPrettyWriter.config());
        SqlCreateType t2 = new SqlCreateType(UnparseUtil.identifier("hazelcast", "public", type.name()), UnparseUtil.nodeList(type.getFields(), f -> new SqlTypeColumn(UnparseUtil.identifier(f.getName()), new SqlDataType(f.getType(), SqlParserPos.ZERO), SqlParserPos.ZERO)), UnparseUtil.reconstructOptions(type.options()), true, false, SqlParserPos.ZERO);
        t2.unparse(writer, 0, 0);
        return writer.toString();
    }

    public String typeName() {
        return (String)this.name.names.get(this.name.names.size() - 1);
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public Stream<SqlTypeColumn> columns() {
        return this.columns.getList().stream().map(node -> (SqlTypeColumn)node);
    }

    public Map<String, String> options() {
        return this.options.getList().stream().map(node -> (SqlOption)node).collect(LinkedHashMap::new, (map, option) -> map.putIfAbsent(option.keyString(), option.valueString()), Map::putAll);
    }
}

