/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.impl.CalciteSqlOptimizer;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.schema.AbstractRelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TypeUtils;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class KvMetadataResolvers {
    private static final Pattern EXT_NAME_PATTERN = Pattern.compile("((" + QueryPath.KEY + "|" + QueryPath.VALUE + ")\\.)?[^.]+");
    private static final Set<String> NESTED_FIELDS_SUPPORTED_FORMATS = Set.of("java", "portable", "compact", "avro");
    private final Map<String, KvMetadataResolver> keyResolvers;
    private final Map<String, KvMetadataResolver> valueResolvers;

    public KvMetadataResolvers(KvMetadataResolver ... resolvers) {
        this(resolvers, resolvers);
    }

    public KvMetadataResolvers(KvMetadataResolver[] keyResolvers, KvMetadataResolver[] valueResolvers) {
        this.keyResolvers = this.resolversMap(keyResolvers);
        this.valueResolvers = this.resolversMap(valueResolvers);
    }

    private Map<String, KvMetadataResolver> resolversMap(KvMetadataResolver[] resolvers) {
        return Arrays.stream(resolvers).flatMap(resolver -> resolver.supportedFormats().map(format -> Util.entry((Object)format, (Object)resolver))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<MappingField> resolveAndValidateFields(List<MappingField> userFields, Map<String, String> options, NodeEngine nodeEngine) {
        Stream<MappingField> valueFields;
        InternalSerializationService serializationService = (InternalSerializationService)nodeEngine.getSerializationService();
        AbstractRelationsStorage relationsStorage = ((CalciteSqlOptimizer)nodeEngine.getSqlService().getOptimizer()).relationsStorage();
        for (MappingField field2 : userFields) {
            String name = field2.name();
            Object externalName = field2.externalName();
            if (externalName == null) {
                externalName = name.equals(QueryPath.KEY) || name.equals(QueryPath.VALUE) ? name : QueryPath.VALUE_PREFIX + name;
                field2.setExternalName(name);
            }
            if (name.equals(QueryPath.KEY) && !((String)externalName).equals(QueryPath.KEY) || name.equals(QueryPath.VALUE) && !((String)externalName).equals(QueryPath.VALUE)) {
                throw QueryException.error((String)("Cannot rename field: '" + name + "'"));
            }
            if (EXT_NAME_PATTERN.matcher((CharSequence)externalName).matches()) continue;
            throw QueryException.error((String)("Invalid external name: " + (String)externalName));
        }
        Stream<MappingField> keyFields = this.resolveAndValidateFields(true, userFields, options, serializationService, relationsStorage);
        Map fields = Stream.concat(keyFields, valueFields = this.resolveAndValidateFields(false, userFields, options, serializationService, relationsStorage)).collect(LinkedHashMap::new, (map, field) -> map.putIfAbsent(field.name(), field), Map::putAll);
        if (fields.isEmpty()) {
            throw QueryException.error((String)"The resolved field list is empty");
        }
        return new ArrayList<MappingField>(fields.values());
    }

    private Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService, AbstractRelationsStorage relationsStorage) {
        List<MappingField> fieldsWithCustomTypes;
        String format = KvMetadataResolvers.getFormat(options, isKey);
        if (format != null && NESTED_FIELDS_SUPPORTED_FORMATS.contains(format) && !(fieldsWithCustomTypes = KvMetadataResolver.extractFields(userFields, isKey).values().stream().filter(mappingField -> mappingField.type().isCustomType()).collect(Collectors.toList())).isEmpty()) {
            TypeUtils.FieldEnricher<?, ?> enricher = TypeUtils.getFieldEnricher(format, serializationService, relationsStorage);
            fieldsWithCustomTypes.forEach(mappingField -> enricher.enrich((MappingField)mappingField, options, isKey));
        }
        String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
        return this.findMetadataResolver(options, isKey).resolveAndValidateFields(isKey, userFields, options, serializationService).filter(field -> !field.name().equals(name) || field.externalName().equals(name));
    }

    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        KvMetadataResolver resolver = this.findMetadataResolver(options, isKey);
        return Objects.requireNonNull(resolver.resolveMetadata(isKey, resolvedFields, options, serializationService));
    }

    private KvMetadataResolver findMetadataResolver(Map<String, String> options, boolean isKey) {
        String option;
        String format;
        KvMetadataResolver resolver = (isKey ? this.keyResolvers : this.valueResolvers).get(format = options.get(option = isKey ? "keyFormat" : "valueFormat"));
        if (resolver == null) {
            if (format == null) {
                throw QueryException.error((String)("Missing '" + option + "' option"));
            }
            throw QueryException.error((String)("Unsupported serialization format: " + format));
        }
        return resolver;
    }

    @Nullable
    private static String getFormat(Map<String, String> options, boolean isKey) {
        return options.get(isKey ? "keyFormat" : "valueFormat");
    }
}

