/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.connector.jdbc.ParamCollectingVisitor;
import com.hazelcast.jet.sql.impl.connector.jdbc.SelectQueryBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.sql.impl.expression.predicate.OrPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class IndexScanSelectQueryBuilder
extends AbstractQueryBuilder {
    protected static final String ROW_NUMBER = "replacerownumber";
    protected static final String ROW_NUMBER_ALIAS = "CONFIDENTIAL_ROWNUM";
    private final List<Integer> dynamicParams = new ArrayList<Integer>();
    private final List<FunctionEx<Object, ?>> converters = new ArrayList();

    IndexScanSelectQueryBuilder(JdbcTable table, SqlDialect dialect, RexNode predicate, List<RexNode> projection, JetJoinInfo joinInfo) {
        super(table, dialect);
        SelectQueryBuilder selectQueryBuilder = new SelectQueryBuilder(table, dialect, null, projection){

            @Override
            protected void appendProjection(StringBuilder sb, List<RexNode> projection) {
                super.appendProjection(sb, projection);
                sb.append(",").append(IndexScanSelectQueryBuilder.ROW_NUMBER).append(" AS ").append(IndexScanSelectQueryBuilder.ROW_NUMBER_ALIAS);
            }
        };
        this.query = selectQueryBuilder.query();
        this.converters.addAll(selectQueryBuilder.converters());
        this.converters.add(FunctionEx.identity());
        StringBuilder stringBuilder = new StringBuilder(this.query);
        this.appendIndices(stringBuilder, joinInfo);
        this.appendPredicate(stringBuilder, predicate, this.dynamicParams);
        this.query = stringBuilder.toString();
    }

    private void appendIndices(StringBuilder stringBuilder, JetJoinInfo joinInfo) {
        stringBuilder.append(" WHERE ");
        String delimiter = "AND ";
        if (joinInfo.condition() instanceof OrPredicate) {
            delimiter = "OR ";
        }
        int[] rightEquiJoinIndices = joinInfo.rightEquiJoinIndices();
        String whereClause = Arrays.stream(rightEquiJoinIndices).mapToObj(index -> {
            JdbcTableField jdbcTableField = (JdbcTableField)this.jdbcTable.getField(index);
            String quotedIdentifier = this.dialect.quoteIdentifier(jdbcTableField.externalName());
            return quotedIdentifier + " = ? ";
        }).collect(Collectors.joining(delimiter));
        stringBuilder.append(whereClause);
    }

    @Override
    protected void appendPredicate(StringBuilder sb, RexNode predicate, List<Integer> parameterPositions) {
        if (predicate != null) {
            SqlNode sqlNode = this.context.toSql(null, predicate);
            sqlNode.accept(new ParamCollectingVisitor(parameterPositions));
            String predicateFragment = sqlNode.toSqlString(this.dialect).toString();
            sb.append(" AND ").append(predicateFragment);
        }
    }

    public List<FunctionEx<Object, ?>> converters() {
        return this.converters;
    }
}

