/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.file.FileSqlConnector;
import com.hazelcast.jet.sql.impl.schema.HazelcastDynamicTableFunction;
import com.hazelcast.jet.sql.impl.schema.HazelcastSqlOperandMetadata;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.HazelcastOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlBasicCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FileTableFunction
extends HazelcastDynamicTableFunction {
    private static final String SCHEMA_NAME_FILES = "files";
    private static final List<HazelcastTableFunctionParameter> PARAMETERS = Arrays.asList(new HazelcastTableFunctionParameter(0, "path", SqlTypeName.VARCHAR, false, TypedOperandChecker.VARCHAR), new HazelcastTableFunctionParameter(1, "glob", SqlTypeName.VARCHAR, true, TypedOperandChecker.VARCHAR), new HazelcastTableFunctionParameter(2, "sharedFileSystem", SqlTypeName.VARCHAR, true, TypedOperandChecker.VARCHAR), new HazelcastTableFunctionParameter(3, "options", SqlTypeName.MAP, true, TypedOperandChecker.MAP));

    public FileTableFunction(String name, String format) {
        super(name, FileOperandMetadata.INSTANCE, (List<Object> arguments) -> FileTableFunction.toTable(arguments, format));
    }

    private static Table toTable(List<Object> arguments, String format) {
        Map<String, Object> options = FileTableFunction.toOptions(arguments, format);
        List<MappingField> fields = FileSqlConnector.resolveAndValidateFields(options, Collections.emptyList());
        return FileSqlConnector.createTable(SCHEMA_NAME_FILES, FileTableFunction.randomName(), options, fields);
    }

    private static Map<String, Object> toOptions(List<Object> arguments, String format) {
        assert (arguments.size() == PARAMETERS.size());
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("format", format);
        for (int i = 0; i < arguments.size(); ++i) {
            if (arguments.get(i) == null) continue;
            options.put(PARAMETERS.get(i).name(), arguments.get(i));
        }
        return options;
    }

    private static String randomName() {
        return "files_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }

    @Override
    public List<Permission> permissions(SqlCall call, HazelcastSqlValidator validator) {
        SqlNode astPath = FileTableFunction.findOperandByName("path", call);
        if (astPath == null && call.operandCount() > 0) {
            astPath = FileTableFunction.findOperandByPosition(0, call);
        }
        if (astPath == null) {
            this.throwCantDeterminePath();
        }
        if (SqlUtil.isNullLiteral(astPath, true)) {
            this.throwCantDeterminePath();
        }
        if (astPath instanceof SqlLiteral) {
            String path = FileTableFunction.extractStringValue((SqlLiteral)astPath);
            if (path != null) {
                return Collections.singletonList(ConnectorPermission.file((String)path, (String)"read"));
            }
            this.throwCantDeterminePath();
        } else if (astPath instanceof SqlDynamicParam) {
            Object pathObj = validator.getRawArgumentAt(((SqlDynamicParam)astPath).getIndex());
            if (pathObj instanceof String) {
                String path = (String)pathObj;
                return Collections.singletonList(ConnectorPermission.file((String)path, (String)"read"));
            }
            this.throwCantDeterminePath();
        }
        return Collections.emptyList();
    }

    private void throwCantDeterminePath() {
        throw QueryException.error((String)"Can't determine the file path, query is denied in secure environment");
    }

    private static SqlNode findOperandByName(String name, SqlCall call) {
        for (int i = 0; i < call.operandCount(); ++i) {
            SqlCall assignment;
            SqlIdentifier id;
            if (!(call.operand(i) instanceof SqlBasicCall) || !name.equals((id = (SqlIdentifier)(assignment = (SqlCall)call.operand(i)).operand(1)).getSimple())) continue;
            return assignment.operand(0);
        }
        return null;
    }

    private static SqlNode findOperandByPosition(int pos, SqlCall call) {
        if (call.operand(pos) instanceof SqlLiteral) {
            return call.operand(pos);
        }
        return null;
    }

    private static final class FileOperandMetadata
    extends HazelcastSqlOperandMetadata {
        private static final FileOperandMetadata INSTANCE = new FileOperandMetadata();

        private FileOperandMetadata() {
            super(PARAMETERS, new HazelcastOperandTypeInference(PARAMETERS, new ReplaceUnknownOperandTypeInference(SqlTypeName.ANY)));
        }

        @Override
        protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
            return true;
        }
    }
}

