/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiLineString;
import java.util.Random;

public class PerturbedGridPolygonBuilder {
    private GeometryFactory geomFactory;
    private double gridWidth = 1000.0;
    private int numLines = 10;
    private double lineWidth = 20.0;
    private long seed = 0L;
    private Random rand;
    private Geometry grid;

    public PerturbedGridPolygonBuilder(GeometryFactory geomFactory) {
        this.geomFactory = geomFactory;
        this.seed = System.currentTimeMillis();
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setNumLines(int numLines) {
        this.numLines = numLines;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Geometry getGeometry() {
        if (this.grid == null) {
            this.grid = this.buildGrid();
        }
        return this.grid;
    }

    private Geometry buildGrid() {
        LineString line;
        Coordinate p1;
        Coordinate p0;
        int i;
        LineString[] lines = new LineString[this.numLines * 2];
        int index = 0;
        for (i = 0; i < this.numLines; ++i) {
            p0 = new Coordinate(this.getRandOrdinate(), 0.0);
            p1 = new Coordinate(this.getRandOrdinate(), this.gridWidth);
            line = this.geomFactory.createLineString(new Coordinate[]{p0, p1});
            lines[index++] = line;
        }
        for (i = 0; i < this.numLines; ++i) {
            p0 = new Coordinate(0.0, this.getRandOrdinate());
            p1 = new Coordinate(this.gridWidth, this.getRandOrdinate());
            line = this.geomFactory.createLineString(new Coordinate[]{p0, p1});
            lines[index++] = line;
        }
        MultiLineString ml = this.geomFactory.createMultiLineString(lines);
        Geometry grid = ml.buffer(this.lineWidth);
        return grid;
    }

    private double getRand() {
        if (this.rand == null) {
            this.rand = new Random(this.seed);
        }
        return this.rand.nextDouble();
    }

    private double getRandOrdinate() {
        double randNum = this.getRand();
        double ord = this.geomFactory.getPrecisionModel().makePrecise(randNum * this.gridWidth);
        return ord;
    }
}

