/*
 * Decompiled with CFR 0.152.
 */
package test.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import java.io.IOException;
import test.jts.geom.GeometryTestFactory;

public class CoordinateSequenceExperiment2 {
    GeometryFactory fact = new GeometryFactory(new PrecisionModel(), 0);

    public static void main(String[] args) throws Exception {
        CoordinateSequenceExperiment2 test = new CoordinateSequenceExperiment2();
        test.run();
        System.exit(0);
    }

    public void run() throws IOException {
        int n;
        int factor = 1;
        for (int i = 1; i < 15 && (n = factor * 1000) <= 64000; ++i) {
            factor *= 2;
            this.run2(n);
        }
    }

    public void run(int nPts) {
        double size = 100.0;
        double armLen = 50.0;
        int nArms = 10;
        long startTime = System.currentTimeMillis();
        Polygon poly = GeometryTestFactory.createSineStar(this.fact, 0.0, 0.0, size, armLen, nArms, nPts);
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        String totalTimeStr = totalTime < 10000L ? totalTime + " ms" : (double)totalTime / 1000.0 + " s";
        System.out.println("Sine Star Creation Executed in " + totalTimeStr);
        Polygon box = GeometryTestFactory.createBox(this.fact, 0.0, 0.0, 1, 100.0);
        startTime = System.currentTimeMillis();
        poly.intersects((Geometry)box);
        endTime = System.currentTimeMillis();
        totalTime = endTime - startTime;
        totalTimeStr = totalTime < 10000L ? totalTime + " ms" : (double)totalTime / 1000.0 + " s";
        System.out.println("n Pts: " + nPts + "   Executed in " + totalTimeStr);
    }

    public void run2(int nPts) throws IOException {
        double size = 100.0;
        double armLen = 50.0;
        int nArms = 10;
        long startTime = System.currentTimeMillis();
        Polygon poly = GeometryTestFactory.createSineStar(this.fact, 0.0, 0.0, size, armLen, nArms, nPts);
        Polygon box = GeometryTestFactory.createSineStar(this.fact, 0.0, size / 2.0, size, armLen, nArms, nPts);
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        String totalTimeStr = totalTime < 10000L ? totalTime + " ms" : (double)totalTime / 1000.0 + " s";
        System.out.println("Sine Star Creation Executed in " + totalTimeStr);
        System.out.println("n Pts: " + nPts);
        startTime = System.currentTimeMillis();
        poly.intersects((Geometry)box);
        endTime = System.currentTimeMillis();
        totalTime = endTime - startTime;
        totalTimeStr = totalTime < 10000L ? totalTime + " ms" : (double)totalTime / 1000.0 + " s";
        System.out.println("   Executed in " + totalTimeStr);
    }
}

