/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientSqlResubmissionMode;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.client.SqlResubmissionTestSupport;
import com.hazelcast.test.ClusterFailureTestSupport;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.SlowTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={SlowTest.class, ParallelJVMTest.class})
public class SqlResubmissionStreamTest
extends SqlResubmissionTestSupport {
    private static final int INITIAL_CLUSTER_SIZE = 1;
    private static final int VALUES_PER_SECOND = 10000;
    @Parameterized.Parameter
    public ClusterFailureTestSupport.SingleFailingInstanceClusterFailure clusterFailure;
    @Parameterized.Parameter(value=1)
    public ClientSqlResubmissionMode resubmissionMode;
    private HazelcastInstance client;

    @Parameterized.Parameters(name="clusterFailure:{0}, mode:{1}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        List<ClusterFailureTestSupport.SingleFailingInstanceClusterFailure> failures = Arrays.asList(new ClusterFailureTestSupport.NodeReplacementClusterFailure(), new ClusterFailureTestSupport.NodeShutdownClusterFailure(), new ClusterFailureTestSupport.NetworkProblemClusterFailure(), new ClusterFailureTestSupport.NodeTerminationClusterFailure());
        for (ClientSqlResubmissionMode mode : ClientSqlResubmissionMode.values()) {
            for (ClusterFailureTestSupport.SingleFailingInstanceClusterFailure failure : failures) {
                res.add(new Object[]{failure, mode});
            }
        }
        return res;
    }

    @Before
    public void initFailure() {
        this.clusterFailure.initialize(1, SqlResubmissionStreamTest.smallInstanceConfig());
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSqlConfig().setResubmissionMode(this.resubmissionMode);
        this.client = this.clusterFailure.createClient(clientConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void when_failingSelectAfterSomeDataIsFetched() {
        SqlStatement statement = new SqlStatement("select * from table(generate_stream(10000))");
        SqlResult rows = this.client.getSql().execute(statement);
        try {
            boolean resubmitted = false;
            long expectedValue = 0L;
            int rowsSeen = 0;
            for (SqlRow r : rows) {
                long rowValue = (Long)r.getObject(0);
                if (rowsSeen++ == 5000) {
                    this.clusterFailure.fail();
                }
                if (expectedValue > 0L && rowValue == 0L) {
                    Assert.assertFalse((String)"rows restarted from 0 for the 2nd time", (boolean)resubmitted);
                    resubmitted = true;
                    expectedValue = 0L;
                }
                Assert.assertEquals((long)expectedValue, (long)rowValue);
                ++expectedValue;
                if (!resubmitted) continue;
                break;
            }
            Assert.assertTrue((String)"resubmission didn't happen", (boolean)resubmitted);
        }
        catch (HazelcastSqlException e) {
            if (!this.shouldFailAfterSomeDataIsFetched(this.resubmissionMode)) {
                throw e;
            }
        }
        finally {
            this.clusterFailure.cleanUp();
        }
    }
}

