/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class QueryIdTest
extends CoreSqlTestSupport {
    @Test
    public void testIds() {
        UUID memberId = UUID.randomUUID();
        UUID localId = UUID.randomUUID();
        QueryId id = QueryIdTest.create(memberId, localId);
        Assert.assertEquals((Object)memberId, (Object)id.getMemberId());
        Assert.assertEquals((Object)localId, (Object)id.getLocalId());
    }

    @Test
    public void testEquals() {
        UUID memberId1 = UUID.randomUUID();
        UUID memberId2 = UUID.randomUUID();
        UUID localId1 = UUID.randomUUID();
        UUID localId2 = UUID.randomUUID();
        QueryIdTest.checkEquals(QueryIdTest.create(memberId1, localId1), QueryIdTest.create(memberId1, localId1), true);
        QueryIdTest.checkEquals(QueryIdTest.create(memberId1, localId1), QueryIdTest.create(memberId1, localId2), false);
        QueryIdTest.checkEquals(QueryIdTest.create(memberId1, localId1), QueryIdTest.create(memberId2, localId1), false);
        QueryIdTest.checkEquals(QueryIdTest.create(memberId1, localId1), QueryIdTest.create(memberId2, localId2), false);
    }

    @Test
    public void testMemberId() {
        UUID memberId = UUID.randomUUID();
        QueryId id1 = QueryId.create((UUID)memberId);
        QueryId id2 = QueryId.create((UUID)memberId);
        Assert.assertEquals((Object)memberId, (Object)id2.getMemberId());
        Assert.assertEquals((Object)id1.getMemberId(), (Object)id2.getMemberId());
        Assert.assertNotEquals((Object)id1.getLocalId(), (Object)id2.getLocalId());
    }

    @Test
    public void testSerialization() {
        QueryId original = QueryId.create((UUID)UUID.randomUUID());
        QueryId restored = (QueryId)QueryIdTest.serializeAndCheck(original, SqlDataSerializerHook.F_ID, 1);
        Assert.assertEquals((Object)original, (Object)restored);
    }

    @Test
    public void testParsing() {
        QueryId original = QueryId.create((UUID)UUID.randomUUID());
        QueryId restored = QueryId.parse((String)original.toString());
        Assert.assertEquals((Object)original, (Object)restored);
        QueryIdTest.assertThrows(IllegalArgumentException.class, () -> QueryId.parse((String)UUID.randomUUID().toString()));
        QueryIdTest.assertThrows(IllegalArgumentException.class, () -> QueryId.parse((String)(String.valueOf(UUID.randomUUID()) + "_")));
        QueryIdTest.assertThrows(IllegalArgumentException.class, () -> QueryId.parse((String)(String.valueOf(UUID.randomUUID()) + "!_" + String.valueOf(UUID.randomUUID()))));
        QueryIdTest.assertThrows(IllegalArgumentException.class, () -> QueryId.parse((String)(String.valueOf(UUID.randomUUID()) + "_" + String.valueOf(UUID.randomUUID()) + "!")));
        QueryIdTest.assertThrows(IllegalArgumentException.class, () -> QueryId.parse((String)(String.valueOf(UUID.randomUUID()) + "_" + String.valueOf(UUID.randomUUID()) + "_")));
        QueryIdTest.assertThrows(IllegalArgumentException.class, () -> QueryId.parse((String)(String.valueOf(UUID.randomUUID()) + "_" + String.valueOf(UUID.randomUUID()) + "_" + String.valueOf(UUID.randomUUID()))));
    }

    private static QueryId create(UUID memberId, UUID localId) {
        return new QueryId(memberId.getMostSignificantBits(), memberId.getLeastSignificantBits(), localId.getMostSignificantBits(), localId.getLeastSignificantBits());
    }
}

