/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.OverridePropertyRule;
import org.junit.Assert;
import org.junit.ClassRule;

public class CoreSqlTestSupport
extends HazelcastTestSupport {
    @ClassRule
    public static OverridePropertyRule enableJetRule = OverridePropertyRule.set((String)"hz.jet.enabled", (String)"true");

    public static void checkEquals(Object first, Object second, boolean expected) {
        if (expected) {
            Assert.assertEquals((Object)first, (Object)second);
            Assert.assertEquals((long)first.hashCode(), (long)second.hashCode());
        } else {
            Assert.assertNotEquals((Object)first, (Object)second);
        }
    }

    public static <T> T serializeAndCheck(Object original, int expectedClassId) {
        return CoreSqlTestSupport.serializeAndCheck(original, JetSqlSerializerHook.F_ID, expectedClassId);
    }

    public static <T> T serializeAndCheck(Object original, int expectedFactoryId, int expectedClassId) {
        CoreSqlTestSupport.assertInstanceOf(IdentifiedDataSerializable.class, (Object)original);
        IdentifiedDataSerializable original0 = (IdentifiedDataSerializable)original;
        Assert.assertEquals((long)expectedFactoryId, (long)original0.getFactoryId());
        Assert.assertEquals((long)expectedClassId, (long)original0.getClassId());
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        return (T)ss.toObject((Object)ss.toData(original));
    }
}

