/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.slf4j.eventTest;

import com.hazelcast.shaded.org.slf4j.Marker;
import com.hazelcast.shaded.org.slf4j.event.EventRecordingLogger;
import com.hazelcast.shaded.org.slf4j.event.Level;
import com.hazelcast.shaded.org.slf4j.event.SubstituteLoggingEvent;
import com.hazelcast.shaded.org.slf4j.helpers.BasicMarkerFactory;
import com.hazelcast.shaded.org.slf4j.helpers.SubstituteLogger;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventRecordingLoggerTest {
    private Queue<SubstituteLoggingEvent> queue;
    private EventRecordingLogger logger;
    private String message;
    private Object param1;
    private Object param2;
    private Object param3;
    private Object[] oneParam;
    private Object[] twoParams;
    private Object[] threeParams;
    private Throwable exception;
    private Marker marker;

    @Before
    public void setUp() {
        this.queue = new LinkedBlockingQueue<SubstituteLoggingEvent>();
        this.logger = new EventRecordingLogger(new SubstituteLogger("testLogger", this.queue, true), this.queue);
        this.message = "Test message with 3 parameters {} {} {} {}";
        this.param1 = 1;
        this.param2 = 2;
        this.param3 = 3;
        this.oneParam = new Object[]{this.param1};
        this.twoParams = new Object[]{this.param1, this.param2};
        this.threeParams = new Object[]{this.param1, this.param2, this.param3};
        this.exception = new IllegalStateException("We just need an exception");
        this.marker = new BasicMarkerFactory().getMarker("testMarker");
    }

    @After
    public void tearDown() {
        Assert.assertTrue((boolean)this.queue.isEmpty());
    }

    @Test
    public void singleMessage() {
        for (Level level : Level.values()) {
            this.singleMessageCheck(level);
        }
    }

    private void singleMessageCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.message);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.message);
                break;
            }
            case INFO: {
                this.logger.info(this.message);
                break;
            }
            case WARN: {
                this.logger.warn(this.message);
                break;
            }
            case ERROR: {
                this.logger.error(this.message);
            }
        }
        this.verifyMessageWithoutMarker(level, null, null);
    }

    @Test
    public void oneParameter() {
        for (Level level : Level.values()) {
            this.oneParameterCheck(level);
        }
    }

    private void oneParameterCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.message, this.param1);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.message, this.param1);
                break;
            }
            case INFO: {
                this.logger.info(this.message, this.param1);
                break;
            }
            case WARN: {
                this.logger.warn(this.message, this.param1);
                break;
            }
            case ERROR: {
                this.logger.error(this.message, this.param1);
            }
        }
        this.verifyMessageWithoutMarker(level, this.oneParam, null);
    }

    @Test
    public void messageTwoParameters() {
        for (Level level : Level.values()) {
            this.messageTwoParametersCheck(level);
        }
    }

    private void messageTwoParametersCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.message, this.param1, this.param2);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.message, this.param1, this.param2);
                break;
            }
            case INFO: {
                this.logger.info(this.message, this.param1, this.param2);
                break;
            }
            case WARN: {
                this.logger.warn(this.message, this.param1, this.param2);
                break;
            }
            case ERROR: {
                this.logger.error(this.message, this.param1, this.param2);
            }
        }
        this.verifyMessageWithoutMarker(level, this.twoParams, null);
    }

    @Test
    public void traceMessageThreeParameters() {
        for (Level level : Level.values()) {
            this.threeParameterCheck(level);
        }
    }

    private void threeParameterCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.message, new Object[]{this.param1, this.param2, this.param3});
                break;
            }
            case DEBUG: {
                this.logger.debug(this.message, new Object[]{this.param1, this.param2, this.param3});
                break;
            }
            case INFO: {
                this.logger.info(this.message, new Object[]{this.param1, this.param2, this.param3});
                break;
            }
            case WARN: {
                this.logger.warn(this.message, new Object[]{this.param1, this.param2, this.param3});
                break;
            }
            case ERROR: {
                this.logger.error(this.message, new Object[]{this.param1, this.param2, this.param3});
            }
        }
        this.verifyMessageWithoutMarker(level, this.threeParams, null);
    }

    @Test
    public void testMessageThrowable() {
        for (Level level : Level.values()) {
            this.throwableCheck(level);
        }
    }

    private void throwableCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.message, this.exception);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.message, this.exception);
                break;
            }
            case INFO: {
                this.logger.info(this.message, this.exception);
                break;
            }
            case WARN: {
                this.logger.warn(this.message, this.exception);
                break;
            }
            case ERROR: {
                this.logger.error(this.message, this.exception);
            }
        }
        this.verifyMessageWithoutMarker(level, null, this.exception);
    }

    @Test
    public void traceMessageOneParameterThrowable() {
        for (Level level : Level.values()) {
            this.oneParamThrowableCheck(level);
        }
    }

    private void oneParamThrowableCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.message, this.param1, (Object)this.exception);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.message, this.param1, (Object)this.exception);
                break;
            }
            case INFO: {
                this.logger.info(this.message, this.param1, (Object)this.exception);
                break;
            }
            case WARN: {
                this.logger.warn(this.message, this.param1, (Object)this.exception);
                break;
            }
            case ERROR: {
                this.logger.error(this.message, this.param1, (Object)this.exception);
            }
        }
        this.verifyMessageWithoutMarker(level, this.oneParam, this.exception);
    }

    @Test
    public void traceMessageTwoParametersThrowable() {
        for (Level level : Level.values()) {
            this.twoParamThrowableCheck(level);
        }
    }

    private void twoParamThrowableCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.message, new Object[]{this.param1, this.param2, this.exception});
                break;
            }
            case DEBUG: {
                this.logger.debug(this.message, new Object[]{this.param1, this.param2, this.exception});
                break;
            }
            case INFO: {
                this.logger.info(this.message, new Object[]{this.param1, this.param2, this.exception});
                break;
            }
            case WARN: {
                this.logger.warn(this.message, new Object[]{this.param1, this.param2, this.exception});
                break;
            }
            case ERROR: {
                this.logger.error(this.message, new Object[]{this.param1, this.param2, this.exception});
            }
        }
        this.verifyMessageWithoutMarker(level, this.twoParams, this.exception);
    }

    @Test
    public void testMessageThreeParametersThrowable() {
        for (Level level : Level.values()) {
            this.messageWith3ArgsPlusException(level);
        }
    }

    private void messageWith3ArgsPlusException(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
                break;
            }
            case DEBUG: {
                this.logger.debug(this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
                break;
            }
            case INFO: {
                this.logger.info(this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
                break;
            }
            case WARN: {
                this.logger.warn(this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
                break;
            }
            case ERROR: {
                this.logger.error(this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
            }
        }
        this.verifyMessageWithoutMarker(level, this.threeParams, this.exception);
    }

    @Test
    public void markerMessage() {
        for (Level level : Level.values()) {
            this.markerMessageCheck(level);
        }
    }

    private void markerMessageCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.marker, this.message);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.marker, this.message);
                break;
            }
            case INFO: {
                this.logger.info(this.marker, this.message);
                break;
            }
            case WARN: {
                this.logger.warn(this.marker, this.message);
                break;
            }
            case ERROR: {
                this.logger.error(this.marker, this.message);
            }
        }
        this.verifyMessage(level, this.marker, null, null);
    }

    @Test
    public void markerMessageOneParameter() {
        for (Level level : Level.values()) {
            this.markerMessageOneParameter(level);
        }
    }

    private void markerMessageOneParameter(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.marker, this.message, this.param1);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.marker, this.message, this.param1);
                break;
            }
            case INFO: {
                this.logger.info(this.marker, this.message, this.param1);
                break;
            }
            case WARN: {
                this.logger.warn(this.marker, this.message, this.param1);
                break;
            }
            case ERROR: {
                this.logger.error(this.marker, this.message, this.param1);
            }
        }
        this.verifyMessage(level, this.marker, this.oneParam, null);
    }

    @Test
    public void traceMarkerMessageTwoParameters() {
        for (Level level : Level.values()) {
            this.markerMessageTwoParameters(level);
        }
    }

    private void markerMessageTwoParameters(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.marker, this.message, this.param1, this.param2);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.marker, this.message, this.param1, this.param2);
                break;
            }
            case INFO: {
                this.logger.info(this.marker, this.message, this.param1, this.param2);
                break;
            }
            case WARN: {
                this.logger.warn(this.marker, this.message, this.param1, this.param2);
                break;
            }
            case ERROR: {
                this.logger.error(this.marker, this.message, this.param1, this.param2);
            }
        }
        this.verifyMessage(level, this.marker, this.twoParams, null);
    }

    @Test
    public void traceMarkerMessageThreeParameters() {
        for (Level level : Level.values()) {
            this.markerMessageThreeParameters(level);
        }
    }

    private void markerMessageThreeParameters(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3});
                break;
            }
            case DEBUG: {
                this.logger.debug(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3});
                break;
            }
            case INFO: {
                this.logger.info(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3});
                break;
            }
            case WARN: {
                this.logger.warn(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3});
                break;
            }
            case ERROR: {
                this.logger.error(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3});
            }
        }
        this.verifyMessage(level, this.marker, this.threeParams, null);
    }

    @Test
    public void markerMessageThrowable() {
        for (Level level : Level.values()) {
            this.markerMessageThrowable(level);
        }
    }

    private void markerMessageThrowable(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.marker, this.message, this.exception);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.marker, this.message, this.exception);
                break;
            }
            case INFO: {
                this.logger.info(this.marker, this.message, this.exception);
                break;
            }
            case WARN: {
                this.logger.warn(this.marker, this.message, this.exception);
                break;
            }
            case ERROR: {
                this.logger.error(this.marker, this.message, this.exception);
            }
        }
        this.verifyMessage(level, this.marker, null, this.exception);
    }

    @Test
    public void markerMessageOneParameterThrowable() {
        for (Level level : Level.values()) {
            this.markerMessageOneParameterThrowableCheck(level);
        }
    }

    private void markerMessageOneParameterThrowableCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.marker, this.message, this.param1, (Object)this.exception);
                break;
            }
            case DEBUG: {
                this.logger.debug(this.marker, this.message, this.param1, (Object)this.exception);
                break;
            }
            case INFO: {
                this.logger.info(this.marker, this.message, this.param1, (Object)this.exception);
                break;
            }
            case WARN: {
                this.logger.warn(this.marker, this.message, this.param1, (Object)this.exception);
                break;
            }
            case ERROR: {
                this.logger.error(this.marker, this.message, this.param1, (Object)this.exception);
            }
        }
        this.verifyMessage(level, this.marker, this.oneParam, this.exception);
    }

    @Test
    public void traceMarkerMessageTwoParametersThrowable() {
        for (Level level : Level.values()) {
            this.markerMessageTwoParametersThrowableCheck(level);
        }
    }

    private void markerMessageTwoParametersThrowableCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.marker, this.message, new Object[]{this.param1, this.param2, this.exception});
                break;
            }
            case DEBUG: {
                this.logger.debug(this.marker, this.message, new Object[]{this.param1, this.param2, this.exception});
                break;
            }
            case INFO: {
                this.logger.info(this.marker, this.message, new Object[]{this.param1, this.param2, this.exception});
                break;
            }
            case WARN: {
                this.logger.warn(this.marker, this.message, new Object[]{this.param1, this.param2, this.exception});
                break;
            }
            case ERROR: {
                this.logger.error(this.marker, this.message, new Object[]{this.param1, this.param2, this.exception});
            }
        }
        this.verifyMessage(level, this.marker, this.twoParams, this.exception);
    }

    @Test
    public void traceMarkerMessageThreeParametersThrowable() {
        for (Level level : Level.values()) {
            this.markerMessageThreeParametersThrowableCheck(level);
        }
    }

    private void markerMessageThreeParametersThrowableCheck(Level level) {
        switch (level) {
            case TRACE: {
                this.logger.trace(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
                break;
            }
            case DEBUG: {
                this.logger.debug(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
                break;
            }
            case INFO: {
                this.logger.info(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
                break;
            }
            case WARN: {
                this.logger.warn(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
                break;
            }
            case ERROR: {
                this.logger.error(this.marker, this.message, new Object[]{this.param1, this.param2, this.param3, this.exception});
            }
        }
        this.verifyMessage(level, this.marker, this.threeParams, this.exception);
    }

    private void verifyMessageWithoutMarker(Level level, Object[] arguments, Throwable exception) {
        this.verifyMessage(level, null, arguments, exception);
    }

    private void verifyMessage(Level level, Marker marker, Object[] arguments, Throwable exception) {
        Assert.assertEquals((String)"missing event: ", (long)1L, (long)this.queue.size());
        SubstituteLoggingEvent event = this.queue.poll();
        Assert.assertNotNull((Object)event);
        if (marker == null) {
            Assert.assertNull((Object)event.getMarkers());
        } else {
            Assert.assertEquals((Object)marker, event.getMarkers().get(0));
        }
        Assert.assertEquals((Object)this.message, (Object)event.getMessage());
        if (arguments == null) {
            Assert.assertNull((Object)event.getArgumentArray());
        } else {
            Assert.assertArrayEquals((Object[])arguments, (Object[])event.getArgumentArray());
        }
        Assert.assertEquals((String)"wrong level: ", (Object)level, (Object)event.getLevel());
        if (exception == null) {
            Assert.assertNull((Object)event.getThrowable());
        } else {
            Assert.assertEquals((Object)exception, (Object)event.getThrowable());
        }
    }
}

