/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.simplify;

import com.hazelcast.shaded.org.locationtech.jts.simplify.GeometryOperationValidator;
import com.hazelcast.shaded.org.locationtech.jts.simplify.VWSimplifierResult;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class VWSimplifierTest
extends TestCase {
    public VWSimplifierTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(VWSimplifierTest.class);
    }

    public void testEmptyPolygon() throws Exception {
        String geomStr = "POLYGON(EMPTY)";
        new GeometryOperationValidator(VWSimplifierResult.getResult(geomStr, 1.0)).setExpectedResult(geomStr).test();
    }

    public void testPolygonNoReduction() throws Exception {
        new GeometryOperationValidator(VWSimplifierResult.getResult("POLYGON ((20 220, 40 220, 60 220, 80 220, 100 220, 120 220, 140 220, 140 180, 100 180, 60 180, 20 180, 20 220))", 1.0)).test();
    }

    public void testPolygonSpikeInShell() throws Exception {
        new GeometryOperationValidator(VWSimplifierResult.getResult("POLYGON ((1721355.3 693015.146, 1721318.687 693046.251, 1721306.747 693063.038, 1721367.025 692978.29, 1721355.3 693015.146))", 10.0)).setExpectedResult("POLYGON ((1721355.3 693015.146, 1721318.687 693046.251, 1721367.025 692978.29, 1721355.3 693015.146))").test();
    }

    public void testPolygonSpikeInHole() throws Exception {
        new GeometryOperationValidator(VWSimplifierResult.getResult("POLYGON ((1721270 693090, 1721400 693090, 1721400 692960, 1721270 692960, 1721270 693090), (1721355.3 693015.146, 1721318.687 693046.251, 1721306.747 693063.038, 1721367.025 692978.29, 1721355.3 693015.146))", 10.0)).setExpectedResult("POLYGON ((1721270 693090, 1721400 693090, 1721400 692960, 1721270 692960, 1721270 693090), (1721355.3 693015.146, 1721318.687 693046.251, 1721367.025 692978.29, 1721355.3 693015.146))").test();
    }
}

