/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.union;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.match.AreaSimilarityMeasure;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.match.HausdorffSimilarityMeasure;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.match.SimilarityMeasureCombiner;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.operation.union.CascadedPolygonUnion;
import java.util.Collection;

public class CascadedPolygonUnionTester {
    public static final double MIN_SIMILARITY_MEAURE = 0.999999;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    GeometryFactory geomFact = new GeometryFactory();

    public boolean test(Collection geoms, double minimumMeasure) {
        double hausMeasure;
        Geometry union2;
        Geometry union1 = this.unionIterated(geoms);
        double areaMeasure = new AreaSimilarityMeasure().measure(union1, union2 = this.unionCascaded(geoms));
        double overallMeasure = SimilarityMeasureCombiner.combine((double)areaMeasure, (double)(hausMeasure = new HausdorffSimilarityMeasure().measure(union1, union2)));
        return overallMeasure > minimumMeasure;
    }

    public Geometry unionIterated(Collection geoms) {
        Geometry unionAll = null;
        int count = 0;
        for (Geometry geom : geoms) {
            unionAll = unionAll == null ? geom.copy() : unionAll.union(geom);
            if (++count % 100 != 0) continue;
            System.out.print(".");
        }
        return unionAll;
    }

    public Geometry unionCascaded(Collection geoms) {
        return CascadedPolygonUnion.union((Collection)geoms);
    }
}

