/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayEdge;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayGraph;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayLabel;
import java.util.Collection;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class OverlayGraphTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OverlayGraphTest.class);
    }

    public OverlayGraphTest(String name) {
        super(name);
    }

    public void testTriangle() {
        Coordinate[] line1 = this.createLine(0.0, 0.0, 10.0, 10.0);
        Coordinate[] line2 = this.createLine(10.0, 10.0, 0.0, 10.0);
        Coordinate[] line3 = this.createLine(0.0, 10.0, 0.0, 0.0);
        OverlayGraph graph = this.createGraph(line1, line2, line3);
        OverlayEdge e1 = OverlayGraphTest.findEdge(graph, 0.0, 0.0, 10.0, 10.0);
        OverlayEdge e2 = OverlayGraphTest.findEdge(graph, 10.0, 10.0, 0.0, 10.0);
        OverlayEdge e3 = OverlayGraphTest.findEdge(graph, 0.0, 10.0, 0.0, 0.0);
        this.checkNodeValid(e1);
        this.checkNodeValid(e2);
        this.checkNodeValid(e3);
        this.checkNext(e1, e2);
        this.checkNext(e2, e3);
        this.checkNext(e3, e1);
        OverlayEdge e1sym = OverlayGraphTest.findEdge(graph, 10.0, 10.0, 0.0, 0.0);
        OverlayEdge e2sym = OverlayGraphTest.findEdge(graph, 0.0, 10.0, 10.0, 10.0);
        OverlayEdge e3sym = OverlayGraphTest.findEdge(graph, 0.0, 0.0, 0.0, 10.0);
        OverlayGraphTest.assertEquals((Object)e1sym, (Object)e1.sym());
        OverlayGraphTest.assertEquals((Object)e2sym, (Object)e2.sym());
        OverlayGraphTest.assertEquals((Object)e3sym, (Object)e3.sym());
        this.checkNext(e1sym, e3sym);
        this.checkNext(e2sym, e1sym);
        this.checkNext(e3sym, e2sym);
    }

    public void testStar() {
        OverlayGraph graph = new OverlayGraph();
        OverlayEdge e1 = this.addEdge(graph, 5.0, 5.0, 0.0, 0.0);
        OverlayEdge e2 = this.addEdge(graph, 5.0, 5.0, 0.0, 9.0);
        OverlayEdge e3 = this.addEdge(graph, 5.0, 5.0, 9.0, 9.0);
        this.checkNodeValid(e1);
        this.checkNext(e1, e1.symOE());
        this.checkNext(e2, e2.symOE());
        this.checkNext(e3, e3.symOE());
        this.checkPrev(e1, e2.symOE());
        this.checkPrev(e2, e3.symOE());
        this.checkPrev(e3, e1.symOE());
    }

    public void testCCWAfterInserts() {
        Coordinate[] e1 = this.createLine(50.0, 39.0, 35.0, 42.0, 37.0, 30.0);
        Coordinate[] e2 = this.createLine(50.0, 39.0, 50.0, 60.0, 20.0, 60.0);
        Coordinate[] e3 = this.createLine(50.0, 39.0, 68.0, 35.0);
        OverlayGraph graph = this.createGraph(e1, e2, e3);
        OverlayEdge node = graph.getNodeEdge(new Coordinate(50.0, 39.0));
        this.checkNodeValid(node);
    }

    public void testCCWAfterInserts2() {
        Coordinate[] e1 = this.createLine(50.0, 200.0, 0.0, 200.0);
        Coordinate[] e2 = this.createLine(50.0, 200.0, 190.0, 50.0, 50.0, 50.0);
        Coordinate[] e3 = this.createLine(50.0, 200.0, 200.0, 200.0, 0.0, 200.0);
        OverlayGraph graph = this.createGraph(e1, e2, e3);
        OverlayEdge node = graph.getNodeEdge(new Coordinate(50.0, 200.0));
        this.checkNodeValid(node);
    }

    private void checkNext(OverlayEdge e, OverlayEdge eNext) {
        OverlayGraphTest.assertEquals((Object)eNext, (Object)e.next());
    }

    private void checkPrev(OverlayEdge e, OverlayEdge ePrev) {
        OverlayGraphTest.assertEquals((Object)ePrev, (Object)e.prev());
    }

    private void checkNodeValid(OverlayEdge e) {
        boolean isNodeValid = e.isEdgesSorted();
        OverlayGraphTest.assertTrue((String)("Found non-sorted edges around node " + e.toStringNode()), (boolean)isNodeValid);
    }

    private static OverlayEdge findEdge(OverlayGraph graph, double orgx, double orgy, double destx, double desty) {
        Collection edges = graph.getEdges();
        for (OverlayEdge e : edges) {
            if (OverlayGraphTest.isEdgeOrgDest(e, orgx, orgy, destx, desty)) {
                return e;
            }
            if (!OverlayGraphTest.isEdgeOrgDest(e.symOE(), orgx, orgy, destx, desty)) continue;
            return e.symOE();
        }
        return null;
    }

    private static boolean isEdgeOrgDest(OverlayEdge e, double orgx, double orgy, double destx, double desty) {
        if (!OverlayGraphTest.isEqual(e.orig(), orgx, orgy)) {
            return false;
        }
        return OverlayGraphTest.isEqual(e.dest(), destx, desty);
    }

    private static boolean isEqual(Coordinate p, double x, double y) {
        return p.getX() == x && p.getY() == y;
    }

    private OverlayGraph createGraph(Coordinate[] ... edges) {
        OverlayGraph graph = new OverlayGraph();
        for (Coordinate[] e : edges) {
            graph.addEdge(e, new OverlayLabel());
        }
        return graph;
    }

    private OverlayEdge addEdge(OverlayGraph graph, double x1, double y1, double x2, double y2) {
        Coordinate[] pts = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)};
        return graph.addEdge(pts, new OverlayLabel());
    }

    private Coordinate[] createLine(double ... ord) {
        Coordinate[] pts = this.toCoordinates(ord);
        return pts;
    }

    private Coordinate[] toCoordinates(double[] ord) {
        Coordinate[] pts = new Coordinate[ord.length / 2];
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = new Coordinate(ord[2 * i], ord[2 * i + 1]);
        }
        return pts;
    }
}

