/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io;

import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import java.io.IOException;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class WKTReaderParseErrorTest
extends TestCase {
    private GeometryFactory fact = new GeometryFactory();
    private WKTReader rdr = new WKTReader(this.fact);

    public static void main(String[] args) {
        TestRunner.run(WKTReaderParseErrorTest.class);
    }

    public WKTReaderParseErrorTest(String name) {
        super(name);
    }

    public void testExtraLParen() throws IOException {
        this.readWithParseException("POINT (( 1e01 -1E02)");
    }

    public void testMissingOrdinate() throws IOException {
        this.readWithParseException("POINT ( 1e01 )");
    }

    public void testBadChar() throws IOException {
        this.readWithParseException("POINT ( # 1e-04 1E-05)");
    }

    public void testBadExpFormat() throws IOException {
        this.readWithParseException("POINT (1e0a1 1X02)");
    }

    public void testBadExpPlusSign() throws IOException {
        this.readWithParseException("POINT (1e+01 1X02)");
    }

    public void testBadPlusSign() throws IOException {
        this.readWithParseException("POINT ( +1e+01 1X02)");
    }

    public void testBadCharsInType() throws IOException {
        this.readWithParseException("POINTABC ( 0 0 )");
        this.readWithParseException("LINESTRINGABC ( 0 0 )");
        this.readWithParseException("LINEARRINGABC ( 0 0, 0 0, 0 0 )");
        this.readWithParseException("POLYGONABC (( 0 0, 0 0, 0 0, 0 0 ))");
        this.readWithParseException("MULTIPOINTABC (( 0 0 ), ( 0 0 ))");
        this.readWithParseException("MULTILINESTRINGABC (( 0 0, 1 1 ), ( 0 0, 1 1 ))");
        this.readWithParseException("MULTIPOLYGONABC ((( 0 0, 1 1, 2 2, 0 0 )), (( 0 0, 1 1, 2 2, 0 0 )))");
        this.readWithParseException("GEOMETRYCOLLECTIONABC (POINT( 0 0 ), LINESTRING( 0 0, 1 1))");
    }

    public void testBadCharsInTypeZ() throws IOException {
        this.readWithParseException("POINTABCZ ( 0 0 )");
        this.readWithParseException("LINESTRINGABCZ ( 0 0 )");
        this.readWithParseException("LINEARRINGABCZ ( 0 0, 0 0, 0 0 )");
        this.readWithParseException("POLYGONABCZ (( 0 0, 0 0, 0 0, 0 0 ))");
        this.readWithParseException("MULTIPOINTABCZ (( 0 0 ), ( 0 0 ))");
        this.readWithParseException("MULTILINESTRINGABCZ (( 0 0, 1 1 ), ( 0 0, 1 1 ))");
        this.readWithParseException("MULTIPOLYGONABCZ ((( 0 0, 1 1, 2 2, 0 0 )), (( 0 0, 1 1, 2 2, 0 0 )))");
        this.readWithParseException("GEOMETRYCOLLECTIONABCZ (POINT( 0 0 ), LINESTRING( 0 0, 1 1))");
    }

    public void testBadCharsInTypeM() throws IOException {
        this.readWithParseException("LINESTRINGABCM ( 0 0 0, 1 1 1 )");
    }

    public void testBadCharsInTypeZM() throws IOException {
        this.readWithParseException("LINESTRINGABCZM ( 0 0 0 0, 1 1 1 1 )");
    }

    private void readWithParseException(String wkt) throws IOException {
        boolean threwParseEx = false;
        try {
            this.rdr.read(wkt);
        }
        catch (ParseException ex) {
            threwParseEx = true;
        }
        WKTReaderParseErrorTest.assertTrue((boolean)threwParseEx);
    }
}

