/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.generator;

import com.hazelcast.shaded.org.locationtech.jts.generator.GridGenerator;
import com.hazelcast.shaded.org.locationtech.jts.generator.LineStringGenerator;
import com.hazelcast.shaded.org.locationtech.jts.generator.MultiGenerator;
import com.hazelcast.shaded.org.locationtech.jts.generator.PointGenerator;
import com.hazelcast.shaded.org.locationtech.jts.generator.PolygonGenerator;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;

public abstract class GeometryGenerator {
    protected int dimensions = 2;
    protected GeometryFactory geometryFactory;
    protected Envelope boundingBox;

    public abstract Geometry create();

    public static GridGenerator createGridGenerator() {
        return new GridGenerator();
    }

    public static PointGenerator createPointGenerator() {
        return new PointGenerator();
    }

    public static LineStringGenerator createLineStringGenerator() {
        LineStringGenerator lsg = new LineStringGenerator();
        lsg.setGenerationAlgorithm(0);
        lsg.setNumberPoints(10);
        return lsg;
    }

    public static PolygonGenerator createPolygonGenerator() {
        PolygonGenerator pg = new PolygonGenerator();
        pg.setGenerationAlgorithm(1);
        pg.setNumberPoints(10);
        pg.setNumberHoles(8);
        return pg;
    }

    public static MultiGenerator createMultiPointGenerator() {
        MultiGenerator mg = new MultiGenerator(GeometryGenerator.createPointGenerator());
        mg.setNumberGeometries(4);
        return mg;
    }

    public static MultiGenerator createMultiLineStringGenerator() {
        MultiGenerator mg = new MultiGenerator(GeometryGenerator.createLineStringGenerator());
        mg.setNumberGeometries(4);
        return mg;
    }

    public static MultiGenerator createMultiPolygonGenerator() {
        MultiGenerator mg = new MultiGenerator(GeometryGenerator.createPolygonGenerator());
        mg.setNumberGeometries(4);
        return mg;
    }

    public Envelope getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(Envelope boundingBox) {
        this.boundingBox = boundingBox;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
        throw new RuntimeException("Dimensions other than 2 are not yet supported");
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }
}

