/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm.construct;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.construct.MaximumInscribedCircle;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class MaximumInscibedCircleTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(MaximumInscibedCircleTest.class);
    }

    public MaximumInscibedCircleTest(String name) {
        super(name);
    }

    public void testSquare() {
        this.checkCircle("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))", 0.001, 150.0, 150.0, 50.0);
    }

    public void testDiamond() {
        this.checkCircle("POLYGON ((150 250, 50 150, 150 50, 250 150, 150 250))", 0.001, 150.0, 150.0, 70.71);
    }

    public void testCircle() {
        Geometry centre = this.read("POINT (100 100)");
        Geometry circle = centre.buffer(100.0, 20);
        this.checkCircle(circle, 0.01, 100.0, 100.0, 99.92);
    }

    public void testKite() {
        this.checkCircle("POLYGON ((100 0, 200 200, 300 200, 300 100, 100 0))", 0.01, 238.19, 138.19, 61.8);
    }

    public void testKiteWithHole() {
        this.checkCircle("POLYGON ((100 0, 200 200, 300 200, 300 100, 100 0), (200 150, 200 100, 260 100, 200 150))", 0.01, 257.47, 157.47, 42.52);
    }

    public void testDoubleKite() {
        this.checkCircle("MULTIPOLYGON (((150 200, 100 150, 150 100, 250 150, 150 200)), ((400 250, 300 150, 400 50, 560 150, 400 250)))", 0.01, 411.38, 149.99, 78.75);
    }

    public void testCollapsedLine() {
        this.checkCircle("POLYGON ((100 100, 200 200, 100 100, 100 100))", 0.01, 150.0, 150.0, 0.0);
    }

    public void testCollapsedLineFlat() {
        this.checkCircle("POLYGON((1 2, 1 2, 1 2, 1 2, 3 2, 1 2))", 0.01, 2.0, 2.0, 0.0);
    }

    public void testCollapsedPoint() {
        this.checkCircle("POLYGON ((100 100, 100 100, 100 100, 100 100))", 0.01, 100.0, 100.0, 0.0);
    }

    private void checkCircle(String wkt, double tolerance, double x, double y, double expectedRadius) {
        this.checkCircle(this.read(wkt), tolerance, x, y, expectedRadius);
    }

    private void checkCircle(Geometry geom, double tolerance, double x, double y, double expectedRadius) {
        MaximumInscribedCircle mic = new MaximumInscribedCircle(geom, tolerance);
        Point centerPoint = mic.getCenter();
        Coordinate centerPt = centerPoint.getCoordinate();
        Coordinate expectedCenter = new Coordinate(x, y);
        this.checkEqualXY(expectedCenter, centerPt, tolerance);
        LineString radiusLine = mic.getRadiusLine();
        double actualRadius = radiusLine.getLength();
        MaximumInscibedCircleTest.assertEquals((String)"Radius: ", (double)expectedRadius, (double)actualRadius, (double)tolerance);
        this.checkEqualXY("Radius line center point: ", centerPt, radiusLine.getCoordinateN(0));
        Coordinate radiusPt = mic.getRadiusPoint().getCoordinate();
        this.checkEqualXY("Radius line endpoint point: ", radiusPt, radiusLine.getCoordinateN(1));
    }
}

