/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.Intersection;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class IntersectionTest
extends TestCase {
    private static final double MAX_ABS_ERROR = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(IntersectionTest.class);
    }

    public IntersectionTest(String name) {
        super(name);
    }

    public void testSimple() {
        this.checkIntersection(0.0, 0.0, 10.0, 10.0, 0.0, 10.0, 10.0, 0.0, 5.0, 5.0);
    }

    public void testCollinear() {
        this.checkIntersectionNull(0.0, 0.0, 10.0, 10.0, 20.0, 20.0, 30.0, 30.0);
    }

    public void testParallel() {
        this.checkIntersectionNull(0.0, 0.0, 10.0, 10.0, 10.0, 0.0, 20.0, 10.0);
    }

    public void testAlmostCollinear() {
        this.checkIntersection(3.56134716165017E7, 4257145.306132293, 3.56134777705378E7, 4257160.528222711, 3.561347777505724E7, 4257160.539653536, 3.561347985607389E7, 4257165.9236917, 3.561347777284146E7, 4257160.533920924);
    }

    public void testAlmostCollinearCond() {
        this.checkIntersection(1.6165017, 45.306132293, 7.7705378, 60.528222711, 7.77505724, 60.539653536, 9.85607389, 65.9236917, 7.772841461, 60.5339209242);
    }

    public void testLineSegCross() {
        this.checkIntersectionLineSegment(0.0, 0.0, 0.0, 1.0, -1.0, 9.0, 1.0, 9.0, 0.0, 9.0);
        this.checkIntersectionLineSegment(0.0, 0.0, 0.0, 1.0, -1.0, 2.0, 1.0, 4.0, 0.0, 3.0);
    }

    public void testLineSegTouch() {
        this.checkIntersectionLineSegment(0.0, 0.0, 0.0, 1.0, -1.0, 9.0, 0.0, 9.0, 0.0, 9.0);
        this.checkIntersectionLineSegment(0.0, 0.0, 0.0, 1.0, 0.0, 2.0, 1.0, 4.0, 0.0, 2.0);
    }

    public void testLineSegCollinear() {
        this.checkIntersectionLineSegment(0.0, 0.0, 0.0, 1.0, 0.0, 9.0, 0.0, 8.0, 0.0, 9.0);
    }

    public void testLineSegNone() {
        this.checkIntersectionLineSegmentNull(0.0, 0.0, 0.0, 1.0, 2.0, 9.0, 1.0, 9.0);
        this.checkIntersectionLineSegmentNull(0.0, 0.0, 0.0, 1.0, -2.0, 9.0, -1.0, 9.0);
        this.checkIntersectionLineSegmentNull(0.0, 0.0, 0.0, 1.0, 2.0, 9.0, 1.0, 9.0);
    }

    private void checkIntersection(double p1x, double p1y, double p2x, double p2y, double q1x, double q1y, double q2x, double q2y, double expectedx, double expectedy) {
        Coordinate expected;
        Coordinate p1 = new Coordinate(p1x, p1y);
        Coordinate p2 = new Coordinate(p2x, p2y);
        Coordinate q1 = new Coordinate(q1x, q1y);
        Coordinate q2 = new Coordinate(q2x, q2y);
        Coordinate actual = Intersection.intersection((Coordinate)p1, (Coordinate)p2, (Coordinate)q1, (Coordinate)q2);
        double dist = actual.distance(expected = new Coordinate(expectedx, expectedy));
        IntersectionTest.assertTrue((dist <= 1.0E-5 ? 1 : 0) != 0);
    }

    private void checkIntersectionNull(double p1x, double p1y, double p2x, double p2y, double q1x, double q1y, double q2x, double q2y) {
        Coordinate p1 = new Coordinate(p1x, p1y);
        Coordinate p2 = new Coordinate(p2x, p2y);
        Coordinate q1 = new Coordinate(q1x, q1y);
        Coordinate q2 = new Coordinate(q2x, q2y);
        Coordinate actual = Intersection.intersection((Coordinate)p1, (Coordinate)p2, (Coordinate)q1, (Coordinate)q2);
        IntersectionTest.assertTrue((actual == null ? 1 : 0) != 0);
    }

    private void checkIntersectionLineSegment(double p1x, double p1y, double p2x, double p2y, double q1x, double q1y, double q2x, double q2y, double expectedx, double expectedy) {
        Coordinate expected;
        Coordinate p1 = new Coordinate(p1x, p1y);
        Coordinate p2 = new Coordinate(p2x, p2y);
        Coordinate q1 = new Coordinate(q1x, q1y);
        Coordinate q2 = new Coordinate(q2x, q2y);
        Coordinate actual = Intersection.lineSegment((Coordinate)p1, (Coordinate)p2, (Coordinate)q1, (Coordinate)q2);
        double dist = actual.distance(expected = new Coordinate(expectedx, expectedy));
        IntersectionTest.assertTrue((dist <= 1.0E-5 ? 1 : 0) != 0);
    }

    private void checkIntersectionLineSegmentNull(double p1x, double p1y, double p2x, double p2y, double q1x, double q1y, double q2x, double q2y) {
        Coordinate p1 = new Coordinate(p1x, p1y);
        Coordinate p2 = new Coordinate(p2x, p2y);
        Coordinate q1 = new Coordinate(q1x, q1y);
        Coordinate q2 = new Coordinate(q2x, q2y);
        Coordinate actual = Intersection.lineSegment((Coordinate)p1, (Coordinate)p2, (Coordinate)q1, (Coordinate)q2);
        IntersectionTest.assertTrue((actual == null ? 1 : 0) != 0);
    }
}

