/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.util.OpenIntToDoubleHashMap;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIntToDoubleHashMapTest {
    private Map<Integer, Double> javaMap = new HashMap<Integer, Double>();

    @Before
    public void setUp() throws Exception {
        this.javaMap.put(50, 100.0);
        this.javaMap.put(75, 75.0);
        this.javaMap.put(25, 500.0);
        this.javaMap.put(Integer.MAX_VALUE, (Double)Double.MAX_VALUE);
        this.javaMap.put(0, -1.0);
        this.javaMap.put(1, 0.0);
        this.javaMap.put(33, -0.1);
        this.javaMap.put(23234234, -242343.0);
        this.javaMap.put(23321, (Double)Double.MIN_VALUE);
        this.javaMap.put(-4444, 332.0);
        this.javaMap.put(-1, -2323.0);
        this.javaMap.put(Integer.MIN_VALUE, 44.0);
        this.javaMap.putAll(this.generate());
    }

    private Map<Integer, Double> generate() {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        Random r = new Random();
        for (int i = 0; i < 2000; ++i) {
            map.put(r.nextInt(), r.nextDouble());
        }
        return map;
    }

    private OpenIntToDoubleHashMap createFromJavaMap() {
        OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap();
        for (Map.Entry<Integer, Double> mapEntry : this.javaMap.entrySet()) {
            map.put(mapEntry.getKey().intValue(), mapEntry.getValue().doubleValue());
        }
        return map;
    }

    @Test
    public void testPutAndGetWith0ExpectedSize() {
        OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap(0);
        this.assertPutAndGet(map);
    }

    @Test
    public void testPutAndGetWithExpectedSize() {
        OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap(500);
        this.assertPutAndGet(map);
    }

    @Test
    public void testPutAndGet() {
        OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap();
        this.assertPutAndGet(map);
    }

    private void assertPutAndGet(OpenIntToDoubleHashMap map) {
        this.assertPutAndGet(map, 0, new HashSet<Integer>());
    }

    private void assertPutAndGet(OpenIntToDoubleHashMap map, int mapSize, Set<Integer> keysInMap) {
        Assert.assertEquals((long)mapSize, (long)map.size());
        for (Map.Entry<Integer, Double> mapEntry : this.javaMap.entrySet()) {
            map.put(mapEntry.getKey().intValue(), mapEntry.getValue().doubleValue());
            if (!keysInMap.contains(mapEntry.getKey())) {
                ++mapSize;
            }
            Assert.assertEquals((long)mapSize, (long)map.size());
            Assert.assertTrue((boolean)Precision.equals((double)mapEntry.getValue(), (double)map.get(mapEntry.getKey().intValue()), (int)1));
        }
    }

    @Test
    public void testPutAbsentOnExisting() {
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        int size = this.javaMap.size();
        for (Map.Entry<Integer, Double> mapEntry : this.generateAbsent().entrySet()) {
            map.put(mapEntry.getKey().intValue(), mapEntry.getValue().doubleValue());
            Assert.assertEquals((long)(++size), (long)map.size());
            Assert.assertTrue((boolean)Precision.equals((double)mapEntry.getValue(), (double)map.get(mapEntry.getKey().intValue()), (int)1));
        }
    }

    @Test
    public void testPutOnExisting() {
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        for (Map.Entry<Integer, Double> mapEntry : this.javaMap.entrySet()) {
            map.put(mapEntry.getKey().intValue(), mapEntry.getValue().doubleValue());
            Assert.assertEquals((long)this.javaMap.size(), (long)map.size());
            Assert.assertTrue((boolean)Precision.equals((double)mapEntry.getValue(), (double)map.get(mapEntry.getKey().intValue()), (int)1));
        }
    }

    @Test
    public void testGetAbsent() {
        Map<Integer, Double> generated = this.generateAbsent();
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        for (Map.Entry<Integer, Double> mapEntry : generated.entrySet()) {
            Assert.assertTrue((boolean)Double.isNaN(map.get(mapEntry.getKey().intValue())));
        }
    }

    @Test
    public void testGetFromEmpty() {
        OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap();
        Assert.assertTrue((boolean)Double.isNaN(map.get(5)));
        Assert.assertTrue((boolean)Double.isNaN(map.get(0)));
        Assert.assertTrue((boolean)Double.isNaN(map.get(50)));
    }

    @Test
    public void testRemove() {
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        int mapSize = this.javaMap.size();
        Assert.assertEquals((long)mapSize, (long)map.size());
        for (Map.Entry<Integer, Double> mapEntry : this.javaMap.entrySet()) {
            map.remove(mapEntry.getKey().intValue());
            Assert.assertEquals((long)(--mapSize), (long)map.size());
            Assert.assertTrue((boolean)Double.isNaN(map.get(mapEntry.getKey().intValue())));
        }
        this.assertPutAndGet(map);
    }

    @Test
    public void testRemove2() {
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        int mapSize = this.javaMap.size();
        int count = 0;
        HashSet<Integer> keysInMap = new HashSet<Integer>(this.javaMap.keySet());
        for (Map.Entry<Integer, Double> mapEntry : this.javaMap.entrySet()) {
            keysInMap.remove(mapEntry.getKey());
            map.remove(mapEntry.getKey().intValue());
            Assert.assertEquals((long)(--mapSize), (long)map.size());
            Assert.assertTrue((boolean)Double.isNaN(map.get(mapEntry.getKey().intValue())));
            if (count++ <= 5) continue;
            break;
        }
        this.assertPutAndGet(map, mapSize, keysInMap);
    }

    @Test
    public void testRemoveFromEmpty() {
        OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap();
        Assert.assertTrue((boolean)Double.isNaN(map.remove(50)));
    }

    @Test
    public void testRemoveAbsent() {
        Map<Integer, Double> generated = this.generateAbsent();
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        int mapSize = map.size();
        for (Map.Entry<Integer, Double> mapEntry : generated.entrySet()) {
            map.remove(mapEntry.getKey().intValue());
            Assert.assertEquals((long)mapSize, (long)map.size());
            Assert.assertTrue((boolean)Double.isNaN(map.get(mapEntry.getKey().intValue())));
        }
    }

    private Map<Integer, Double> generateAbsent() {
        HashMap<Integer, Double> generated = new HashMap<Integer, Double>();
        do {
            generated.putAll(this.generate());
            for (Integer key : this.javaMap.keySet()) {
                generated.remove(key);
            }
        } while (generated.size() < 100);
        return generated;
    }

    @Test
    public void testCopy() {
        OpenIntToDoubleHashMap copy = new OpenIntToDoubleHashMap(this.createFromJavaMap());
        Assert.assertEquals((long)this.javaMap.size(), (long)copy.size());
        for (Map.Entry<Integer, Double> mapEntry : this.javaMap.entrySet()) {
            Assert.assertTrue((boolean)Precision.equals((double)mapEntry.getValue(), (double)copy.get(mapEntry.getKey().intValue()), (int)1));
        }
    }

    @Test
    public void testContainsKey() {
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        for (Map.Entry<Integer, Double> mapEntry : this.javaMap.entrySet()) {
            Assert.assertTrue((boolean)map.containsKey(mapEntry.getKey().intValue()));
        }
        for (Map.Entry<Integer, Double> mapEntry : this.generateAbsent().entrySet()) {
            Assert.assertFalse((boolean)map.containsKey(mapEntry.getKey().intValue()));
        }
        for (Map.Entry<Integer, Double> mapEntry : this.javaMap.entrySet()) {
            int key = mapEntry.getKey();
            Assert.assertTrue((boolean)map.containsKey(key));
            map.remove(key);
            Assert.assertFalse((boolean)map.containsKey(key));
        }
    }

    @Test
    public void testIterator() {
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        OpenIntToDoubleHashMap.Iterator iterator = map.iterator();
        for (int i = 0; i < map.size(); ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.advance();
            int key = iterator.key();
            Assert.assertTrue((boolean)map.containsKey(key));
            Assert.assertEquals((double)this.javaMap.get(key), (double)map.get(key), (double)0.0);
            Assert.assertEquals((double)this.javaMap.get(key), (double)iterator.value(), (double)0.0);
            Assert.assertTrue((boolean)this.javaMap.containsKey(key));
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.advance();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentModification() {
        OpenIntToDoubleHashMap map = this.createFromJavaMap();
        OpenIntToDoubleHashMap.Iterator iterator = map.iterator();
        map.put(3, 3.0);
        try {
            iterator.advance();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Test
    public void testPutKeysWithCollisions() {
        OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap();
        int key1 = -1996012590;
        double value1 = 1.0;
        map.put(key1, value1);
        int key2 = 835099822;
        map.put(key2, value1);
        int key3 = 1008859686;
        map.put(key3, value1);
        Assert.assertTrue((boolean)Precision.equals((double)value1, (double)map.get(key3), (int)1));
        Assert.assertEquals((long)3L, (long)map.size());
        map.remove(key2);
        double value2 = 2.0;
        map.put(key3, value2);
        Assert.assertTrue((boolean)Precision.equals((double)value2, (double)map.get(key3), (int)1));
        Assert.assertEquals((long)2L, (long)map.size());
    }

    @Test
    public void testPutKeysWithCollision2() {
        OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap();
        int key1 = 837989881;
        double value1 = 1.0;
        map.put(key1, value1);
        int key2 = 476463321;
        map.put(key2, value1);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)Precision.equals((double)value1, (double)map.get(key2), (int)1));
        map.remove(key1);
        double value2 = 2.0;
        map.put(key2, value2);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)Precision.equals((double)value2, (double)map.get(key2), (int)1));
    }
}

