/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.ZeroException;
import com.hazelcast.shaded.org.apache.commons.math3.util.IntegerSequence;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class IntegerSequenceTest {
    @Test
    public void testRangeMultipleIterations() {
        boolean start = true;
        int max = 7;
        int step = 2;
        ArrayList<Integer> seq = new ArrayList<Integer>();
        IntegerSequence.Range r = IntegerSequence.range((int)1, (int)7, (int)2);
        int numTimes = 3;
        for (int n = 0; n < 3; ++n) {
            seq.clear();
            for (Integer i : r) {
                seq.add(i);
            }
            Assert.assertEquals((long)4L, (long)seq.size());
            Assert.assertEquals((long)seq.size(), (long)r.size());
        }
    }

    @Test
    public void testIncreasingRange() {
        boolean start = true;
        int max = 7;
        int step = 2;
        ArrayList<Integer> seq = new ArrayList<Integer>();
        IntegerSequence.Range r = IntegerSequence.range((int)1, (int)7, (int)2);
        for (Integer i : r) {
            seq.add(i);
        }
        Assert.assertEquals((long)4L, (long)seq.size());
        Assert.assertEquals((long)seq.size(), (long)r.size());
        for (int i = 0; i < seq.size(); ++i) {
            Assert.assertEquals((long)(1 + i * 2), (long)((Integer)seq.get(i)).intValue());
        }
    }

    @Test
    public void testIncreasingRangeNegativeEnd() {
        int start = -10;
        int max = -1;
        int step = 2;
        ArrayList<Integer> seq = new ArrayList<Integer>();
        IntegerSequence.Range r = IntegerSequence.range((int)-10, (int)-1, (int)2);
        for (Integer i : r) {
            seq.add(i);
        }
        Assert.assertEquals((long)5L, (long)seq.size());
        Assert.assertEquals((long)seq.size(), (long)r.size());
        for (int i = 0; i < seq.size(); ++i) {
            Assert.assertEquals((long)(-10 + i * 2), (long)((Integer)seq.get(i)).intValue());
        }
    }

    @Test
    public void testDecreasingRange() {
        int start = 10;
        int max = -8;
        int step = -3;
        ArrayList<Integer> seq = new ArrayList<Integer>();
        IntegerSequence.Range r = IntegerSequence.range((int)10, (int)-8, (int)-3);
        for (Integer i : r) {
            seq.add(i);
        }
        Assert.assertEquals((long)7L, (long)seq.size());
        Assert.assertEquals((long)seq.size(), (long)r.size());
        for (int i = 0; i < seq.size(); ++i) {
            Assert.assertEquals((long)(10 + i * -3), (long)((Integer)seq.get(i)).intValue());
        }
    }

    @Test
    public void testSingleElementRange() {
        boolean start = true;
        boolean max = true;
        int step = -1;
        ArrayList<Integer> seq = new ArrayList<Integer>();
        IntegerSequence.Range r = IntegerSequence.range((int)1, (int)1, (int)-1);
        for (Integer i : r) {
            seq.add(i);
        }
        Assert.assertEquals((long)1L, (long)seq.size());
        Assert.assertEquals((long)seq.size(), (long)r.size());
        Assert.assertEquals((long)1L, (long)((Integer)seq.get(0)).intValue());
    }

    @Test
    public void testBasicRange() {
        int start = -2;
        int end = 4;
        ArrayList<Integer> seq = new ArrayList<Integer>();
        for (Integer i : IntegerSequence.range((int)-2, (int)4)) {
            seq.add(i);
        }
        for (int i = -2; i <= 4; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)seq.get(i - -2)).intValue());
        }
    }

    @Test
    public void testEmptyRange() {
        int start = 2;
        boolean end = false;
        ArrayList<Integer> seq = new ArrayList<Integer>();
        IntegerSequence.Range r = IntegerSequence.range((int)2, (int)0);
        for (Integer i : r) {
            seq.add(i);
        }
        Assert.assertEquals((long)0L, (long)seq.size());
        Assert.assertEquals((long)seq.size(), (long)r.size());
    }

    @Test
    public void testEmptyRangeNegativeStart() {
        int start = -2;
        int max = -1;
        int step = -1;
        ArrayList<Integer> seq = new ArrayList<Integer>();
        IntegerSequence.Range r = IntegerSequence.range((int)-2, (int)-1, (int)-1);
        for (Integer i : r) {
            seq.add(i);
        }
        Assert.assertEquals((long)0L, (long)seq.size());
        Assert.assertEquals((long)seq.size(), (long)r.size());
    }

    @Test(expected=MaxCountExceededException.class)
    public void testIncrementorCountExceeded() {
        boolean start = true;
        int max = 7;
        int step = 2;
        IntegerSequence.Incrementor inc = IntegerSequence.Incrementor.create().withStart(1).withMaximalCount(7).withIncrement(2);
        Assert.assertTrue((boolean)inc.canIncrement(2));
        Assert.assertFalse((boolean)inc.canIncrement(3));
        while (true) {
            inc.increment();
        }
    }

    @Test
    public void testCanIncrementZeroTimes() {
        boolean start = true;
        int max = 2;
        boolean step = true;
        IntegerSequence.Incrementor inc = IntegerSequence.Incrementor.create().withStart(1).withMaximalCount(2).withIncrement(1);
        Assert.assertTrue((boolean)inc.canIncrement(0));
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testIncrementZeroTimes() {
        boolean start = true;
        int max = 2;
        boolean step = true;
        IntegerSequence.Incrementor inc = IntegerSequence.Incrementor.create().withStart(1).withMaximalCount(2).withIncrement(1);
        inc.increment(0);
    }

    @Test(expected=ZeroException.class)
    public void testIncrementZeroStep() {
        boolean step = false;
        IntegerSequence.Incrementor.create().withIncrement(0);
    }

    @Test
    public void testIteratorZeroElement() {
        boolean start = true;
        boolean max = true;
        boolean step = true;
        IntegerSequence.Incrementor inc = IntegerSequence.Incrementor.create().withStart(1).withMaximalCount(1).withIncrement(1);
        Assert.assertFalse((boolean)inc.hasNext());
        try {
            inc.increment();
            Assert.fail((String)"exception expected");
        }
        catch (MaxCountExceededException maxCountExceededException) {
            // empty catch block
        }
    }

    @Test(expected=TooManyEvaluationsException.class)
    public void testIncrementorAlternateException() {
        boolean start = true;
        int max = 2;
        boolean step = true;
        IntegerSequence.Incrementor.MaxCountExceededCallback cb = new IntegerSequence.Incrementor.MaxCountExceededCallback(){

            public void trigger(int max) {
                throw new TooManyEvaluationsException((Number)max);
            }
        };
        IntegerSequence.Incrementor inc = IntegerSequence.Incrementor.create().withStart(1).withMaximalCount(2).withIncrement(1).withCallback(cb);
        try {
            inc.increment();
        }
        catch (RuntimeException e) {
            Assert.fail((String)"unexpected exception");
        }
        inc.increment();
    }
}

