/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.regression;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.random.ISAACRandom;
import com.hazelcast.shaded.org.apache.commons.math3.stat.regression.ModelSpecificationException;
import com.hazelcast.shaded.org.apache.commons.math3.stat.regression.RegressionResults;
import com.hazelcast.shaded.org.apache.commons.math3.stat.regression.SimpleRegression;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class SimpleRegressionTest {
    private double[][] data = new double[][]{{0.1, 0.2}, {338.8, 337.4}, {118.1, 118.2}, {888.0, 884.6}, {9.2, 10.1}, {228.1, 226.5}, {668.5, 666.3}, {998.5, 996.3}, {449.1, 448.6}, {778.9, 777.0}, {559.2, 558.2}, {0.3, 0.4}, {0.1, 0.6}, {778.1, 775.5}, {668.8, 666.9}, {339.3, 338.0}, {448.9, 447.5}, {10.8, 11.6}, {557.7, 556.0}, {228.3, 228.1}, {998.0, 995.8}, {888.8, 887.6}, {119.6, 120.2}, {0.3, 0.3}, {0.6, 0.3}, {557.6, 556.8}, {339.3, 339.1}, {888.0, 887.2}, {998.5, 999.0}, {778.9, 779.0}, {10.2, 11.1}, {117.6, 118.3}, {228.9, 229.2}, {668.4, 669.1}, {449.2, 448.9}, {0.2, 0.5}};
    private double[][] corrData = new double[][]{{101.0, 99.2}, {100.1, 99.0}, {100.0, 100.0}, {90.6, 111.6}, {86.5, 122.2}, {89.7, 117.6}, {90.6, 121.1}, {82.8, 136.0}, {70.1, 154.2}, {65.4, 153.6}, {61.3, 158.5}, {62.5, 140.6}, {63.6, 136.2}, {52.6, 168.0}, {59.7, 154.3}, {59.5, 149.0}, {61.3, 165.5}};
    private double[][] infData = new double[][]{{15.6, 5.2}, {26.8, 6.1}, {37.8, 8.7}, {36.4, 8.5}, {35.5, 8.8}, {18.6, 4.9}, {15.3, 4.5}, {7.9, 2.5}, {0.0, 1.1}};
    private double[][] removeSingle = new double[][]{this.infData[1]};
    private double[][] removeMultiple = new double[][]{this.infData[1], this.infData[2]};
    private double removeX = this.infData[0][0];
    private double removeY = this.infData[0][1];
    private double[][] infData2 = new double[][]{{1.0, 1.0}, {2.0, 0.0}, {3.0, 5.0}, {4.0, 2.0}, {5.0, -1.0}, {6.0, 12.0}};
    private double[][] noint1 = new double[][]{{130.0, 60.0}, {131.0, 61.0}, {132.0, 62.0}, {133.0, 63.0}, {134.0, 64.0}, {135.0, 65.0}, {136.0, 66.0}, {137.0, 67.0}, {138.0, 68.0}, {139.0, 69.0}, {140.0, 70.0}};
    private double[][] noint2 = new double[][]{{3.0, 4.0}, {4.0, 5.0}, {4.0, 6.0}};

    @Test
    public void testAppend() {
        this.check(false);
        this.check(true);
    }

    private void check(boolean includeIntercept) {
        int sets = 2;
        ISAACRandom rand = new ISAACRandom(10L);
        SimpleRegression whole = new SimpleRegression(includeIntercept);
        SimpleRegression parts = new SimpleRegression(includeIntercept);
        for (int s = 0; s < 2; ++s) {
            double coef = rand.nextDouble();
            SimpleRegression sub = new SimpleRegression(includeIntercept);
            for (int i = 0; i < 5; ++i) {
                double x = rand.nextDouble();
                double y = x * coef + rand.nextDouble();
                sub.addData(x, y);
                whole.addData(x, y);
            }
            parts.append(sub);
            Assert.assertTrue((boolean)this.equals(parts, whole, 1.0E-6));
        }
    }

    private boolean equals(SimpleRegression model1, SimpleRegression model2, double tol) {
        if (model1.getN() != model2.getN()) {
            return false;
        }
        if (FastMath.abs((double)(model1.getIntercept() - model2.getIntercept())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getInterceptStdErr() - model2.getInterceptStdErr())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getMeanSquareError() - model2.getMeanSquareError())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getR() - model2.getR())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getRegressionSumSquares() - model2.getRegressionSumSquares())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getRSquare() - model2.getRSquare())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSignificance() - model2.getSignificance())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSlope() - model2.getSlope())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSlopeConfidenceInterval() - model2.getSlopeConfidenceInterval())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSlopeStdErr() - model2.getSlopeStdErr())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSumOfCrossProducts() - model2.getSumOfCrossProducts())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSumSquaredErrors() - model2.getSumSquaredErrors())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getTotalSumSquares() - model2.getTotalSumSquares())) > tol) {
            return false;
        }
        return !(FastMath.abs((double)(model1.getXSumSquares() - model2.getXSumSquares())) > tol);
    }

    @Test
    public void testRegressIfaceMethod() {
        SimpleRegression regression;
        SimpleRegression iface = regression = new SimpleRegression(true);
        SimpleRegression regressionNoint = new SimpleRegression(false);
        SimpleRegression regressionIntOnly = new SimpleRegression(false);
        for (int i = 0; i < this.data.length; ++i) {
            iface.addObservation(new double[]{this.data[i][1]}, this.data[i][0]);
            regressionNoint.addData(this.data[i][1], this.data[i][0]);
            regressionIntOnly.addData(1.0, this.data[i][0]);
        }
        RegressionResults fullReg = iface.regress();
        Assert.assertNotNull((Object)fullReg);
        Assert.assertEquals((String)"intercept", (double)regression.getIntercept(), (double)fullReg.getParameterEstimate(0), (double)1.0E-16);
        Assert.assertEquals((String)"intercept std err", (double)regression.getInterceptStdErr(), (double)fullReg.getStdErrorOfEstimate(0), (double)1.0E-16);
        Assert.assertEquals((String)"slope", (double)regression.getSlope(), (double)fullReg.getParameterEstimate(1), (double)1.0E-16);
        Assert.assertEquals((String)"slope std err", (double)regression.getSlopeStdErr(), (double)fullReg.getStdErrorOfEstimate(1), (double)1.0E-16);
        Assert.assertEquals((String)"number of observations", (long)regression.getN(), (long)fullReg.getN());
        Assert.assertEquals((String)"r-square", (double)regression.getRSquare(), (double)fullReg.getRSquared(), (double)1.0E-16);
        Assert.assertEquals((String)"SSR", (double)regression.getRegressionSumSquares(), (double)fullReg.getRegressionSumSquares(), (double)1.0E-16);
        Assert.assertEquals((String)"MSE", (double)regression.getMeanSquareError(), (double)fullReg.getMeanSquareError(), (double)1.0E-16);
        Assert.assertEquals((String)"SSE", (double)regression.getSumSquaredErrors(), (double)fullReg.getErrorSumSquares(), (double)1.0E-16);
        RegressionResults noInt = iface.regress(new int[]{1});
        Assert.assertNotNull((Object)noInt);
        Assert.assertEquals((String)"slope", (double)regressionNoint.getSlope(), (double)noInt.getParameterEstimate(0), (double)1.0E-12);
        Assert.assertEquals((String)"slope std err", (double)regressionNoint.getSlopeStdErr(), (double)noInt.getStdErrorOfEstimate(0), (double)1.0E-16);
        Assert.assertEquals((String)"number of observations", (long)regressionNoint.getN(), (long)noInt.getN());
        Assert.assertEquals((String)"r-square", (double)regressionNoint.getRSquare(), (double)noInt.getRSquared(), (double)1.0E-16);
        Assert.assertEquals((String)"SSR", (double)regressionNoint.getRegressionSumSquares(), (double)noInt.getRegressionSumSquares(), (double)1.0E-8);
        Assert.assertEquals((String)"MSE", (double)regressionNoint.getMeanSquareError(), (double)noInt.getMeanSquareError(), (double)1.0E-16);
        Assert.assertEquals((String)"SSE", (double)regressionNoint.getSumSquaredErrors(), (double)noInt.getErrorSumSquares(), (double)1.0E-16);
        RegressionResults onlyInt = iface.regress(new int[]{0});
        Assert.assertNotNull((Object)onlyInt);
        Assert.assertEquals((String)"slope", (double)regressionIntOnly.getSlope(), (double)onlyInt.getParameterEstimate(0), (double)1.0E-12);
        Assert.assertEquals((String)"slope std err", (double)regressionIntOnly.getSlopeStdErr(), (double)onlyInt.getStdErrorOfEstimate(0), (double)1.0E-12);
        Assert.assertEquals((String)"number of observations", (long)regressionIntOnly.getN(), (long)onlyInt.getN());
        Assert.assertEquals((String)"r-square", (double)regressionIntOnly.getRSquare(), (double)onlyInt.getRSquared(), (double)1.0E-14);
        Assert.assertEquals((String)"SSE", (double)regressionIntOnly.getSumSquaredErrors(), (double)onlyInt.getErrorSumSquares(), (double)1.0E-8);
        Assert.assertEquals((String)"SSR", (double)regressionIntOnly.getRegressionSumSquares(), (double)onlyInt.getRegressionSumSquares(), (double)1.0E-8);
        Assert.assertEquals((String)"MSE", (double)regressionIntOnly.getMeanSquareError(), (double)onlyInt.getMeanSquareError(), (double)1.0E-8);
    }

    @Test
    public void testRegressExceptions() {
        SimpleRegression noIntRegression = new SimpleRegression(false);
        noIntRegression.addData(this.noint2[0][1], this.noint2[0][0]);
        noIntRegression.addData(this.noint2[1][1], this.noint2[1][0]);
        noIntRegression.addData(this.noint2[2][1], this.noint2[2][0]);
        try {
            noIntRegression.regress(null);
            Assert.fail((String)"Expecting MathIllegalArgumentException for null array");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            noIntRegression.regress(new int[0]);
            Assert.fail((String)"Expecting MathIllegalArgumentException for empty array");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            noIntRegression.regress(new int[]{0, 1});
            Assert.fail((String)"Expecting ModelSpecificationException - too many regressors");
        }
        catch (ModelSpecificationException modelSpecificationException) {
            // empty catch block
        }
        try {
            noIntRegression.regress(new int[]{1});
            Assert.fail((String)"Expecting OutOfRangeException - invalid regression");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        SimpleRegression regression = new SimpleRegression(true);
        regression.addData(this.noint2[0][1], this.noint2[0][0]);
        regression.addData(this.noint2[1][1], this.noint2[1][0]);
        regression.addData(this.noint2[2][1], this.noint2[2][0]);
        try {
            regression.regress(null);
            Assert.fail((String)"Expecting MathIllegalArgumentException for null array");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            regression.regress(new int[0]);
            Assert.fail((String)"Expecting MathIllegalArgumentException for empty array");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{0, 1, 2});
            Assert.fail((String)"Expecting ModelSpecificationException - too many regressors");
        }
        catch (ModelSpecificationException modelSpecificationException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{1, 0});
            Assert.fail((String)"Expecting ModelSpecificationException - invalid regression");
        }
        catch (ModelSpecificationException modelSpecificationException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{3, 4});
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{0, 2});
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{2});
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testNoInterceot_noint2() {
        SimpleRegression regression = new SimpleRegression(false);
        regression.addData(this.noint2[0][1], this.noint2[0][0]);
        regression.addData(this.noint2[1][1], this.noint2[1][0]);
        regression.addData(this.noint2[2][1], this.noint2[2][0]);
        Assert.assertEquals((String)"intercept", (double)0.0, (double)regression.getIntercept(), (double)0.0);
        Assert.assertEquals((String)"slope", (double)0.727272727272727, (double)regression.getSlope(), (double)1.0E-11);
        Assert.assertEquals((String)"slope std err", (double)0.0420827318078432, (double)regression.getSlopeStdErr(), (double)1.0E-11);
        Assert.assertEquals((String)"number of observations", (long)3L, (long)regression.getN());
        Assert.assertEquals((String)"r-square", (double)0.993348115299335, (double)regression.getRSquare(), (double)1.0E-11);
        Assert.assertEquals((String)"SSR", (double)40.7272727272727, (double)regression.getRegressionSumSquares(), (double)1.0E-8);
        Assert.assertEquals((String)"MSE", (double)0.136363636363636, (double)regression.getMeanSquareError(), (double)1.0E-9);
        Assert.assertEquals((String)"SSE", (double)0.272727272727273, (double)regression.getSumSquaredErrors(), (double)1.0E-8);
    }

    @Test
    public void testNoIntercept_noint1() {
        SimpleRegression regression = new SimpleRegression(false);
        for (int i = 0; i < this.noint1.length; ++i) {
            regression.addData(this.noint1[i][1], this.noint1[i][0]);
        }
        Assert.assertEquals((String)"intercept", (double)0.0, (double)regression.getIntercept(), (double)0.0);
        Assert.assertEquals((String)"slope", (double)2.07438016528926, (double)regression.getSlope(), (double)1.0E-11);
        Assert.assertEquals((String)"slope std err", (double)0.0165289256198347, (double)regression.getSlopeStdErr(), (double)1.0E-11);
        Assert.assertEquals((String)"number of observations", (long)11L, (long)regression.getN());
        Assert.assertEquals((String)"r-square", (double)0.999365492298663, (double)regression.getRSquare(), (double)1.0E-11);
        Assert.assertEquals((String)"SSR", (double)200457.727272727, (double)regression.getRegressionSumSquares(), (double)1.0E-8);
        Assert.assertEquals((String)"MSE", (double)12.7272727272727, (double)regression.getMeanSquareError(), (double)1.0E-9);
        Assert.assertEquals((String)"SSE", (double)127.272727272727, (double)regression.getSumSquaredErrors(), (double)1.0E-8);
    }

    @Test
    public void testNorris() {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < this.data.length; ++i) {
            regression.addData(this.data[i][1], this.data[i][0]);
        }
        Assert.assertEquals((String)"slope", (double)1.00211681802045, (double)regression.getSlope(), (double)1.0E-11);
        Assert.assertEquals((String)"slope std err", (double)4.29796848199937E-4, (double)regression.getSlopeStdErr(), (double)1.0E-11);
        Assert.assertEquals((String)"number of observations", (long)36L, (long)regression.getN());
        Assert.assertEquals((String)"intercept", (double)-0.262323073774029, (double)regression.getIntercept(), (double)1.0E-11);
        Assert.assertEquals((String)"std err intercept", (double)0.232818234301152, (double)regression.getInterceptStdErr(), (double)1.0E-11);
        Assert.assertEquals((String)"r-square", (double)0.999993745883712, (double)regression.getRSquare(), (double)1.0E-11);
        Assert.assertEquals((String)"SSR", (double)4255954.13232369, (double)regression.getRegressionSumSquares(), (double)1.0E-8);
        Assert.assertEquals((String)"MSE", (double)0.782864662630069, (double)regression.getMeanSquareError(), (double)1.0E-9);
        Assert.assertEquals((String)"SSE", (double)26.6173985294224, (double)regression.getSumSquaredErrors(), (double)1.0E-8);
        Assert.assertEquals((String)"predict(0)", (double)-0.262323073774029, (double)regression.predict(0.0), (double)1.0E-11);
        Assert.assertEquals((String)"predict(1)", (double)0.7397937442464211, (double)regression.predict(1.0), (double)1.0E-11);
    }

    @Test
    public void testCorr() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.corrData);
        Assert.assertEquals((String)"number of observations", (long)17L, (long)regression.getN());
        Assert.assertEquals((String)"r-square", (double)0.896123, (double)regression.getRSquare(), (double)1.0E-5);
        Assert.assertEquals((String)"r", (double)-0.94663767742, (double)regression.getR(), (double)1.0E-10);
    }

    @Test
    public void testNaNs() {
        SimpleRegression regression = new SimpleRegression();
        Assert.assertTrue((String)"intercept not NaN", (boolean)Double.isNaN(regression.getIntercept()));
        Assert.assertTrue((String)"slope not NaN", (boolean)Double.isNaN(regression.getSlope()));
        Assert.assertTrue((String)"slope std err not NaN", (boolean)Double.isNaN(regression.getSlopeStdErr()));
        Assert.assertTrue((String)"intercept std err not NaN", (boolean)Double.isNaN(regression.getInterceptStdErr()));
        Assert.assertTrue((String)"MSE not NaN", (boolean)Double.isNaN(regression.getMeanSquareError()));
        Assert.assertTrue((String)"e not NaN", (boolean)Double.isNaN(regression.getR()));
        Assert.assertTrue((String)"r-square not NaN", (boolean)Double.isNaN(regression.getRSquare()));
        Assert.assertTrue((String)"RSS not NaN", (boolean)Double.isNaN(regression.getRegressionSumSquares()));
        Assert.assertTrue((String)"SSE not NaN", (boolean)Double.isNaN(regression.getSumSquaredErrors()));
        Assert.assertTrue((String)"SSTO not NaN", (boolean)Double.isNaN(regression.getTotalSumSquares()));
        Assert.assertTrue((String)"predict not NaN", (boolean)Double.isNaN(regression.predict(0.0)));
        regression.addData(1.0, 2.0);
        regression.addData(1.0, 3.0);
        Assert.assertTrue((String)"intercept not NaN", (boolean)Double.isNaN(regression.getIntercept()));
        Assert.assertTrue((String)"slope not NaN", (boolean)Double.isNaN(regression.getSlope()));
        Assert.assertTrue((String)"slope std err not NaN", (boolean)Double.isNaN(regression.getSlopeStdErr()));
        Assert.assertTrue((String)"intercept std err not NaN", (boolean)Double.isNaN(regression.getInterceptStdErr()));
        Assert.assertTrue((String)"MSE not NaN", (boolean)Double.isNaN(regression.getMeanSquareError()));
        Assert.assertTrue((String)"e not NaN", (boolean)Double.isNaN(regression.getR()));
        Assert.assertTrue((String)"r-square not NaN", (boolean)Double.isNaN(regression.getRSquare()));
        Assert.assertTrue((String)"RSS not NaN", (boolean)Double.isNaN(regression.getRegressionSumSquares()));
        Assert.assertTrue((String)"SSE not NaN", (boolean)Double.isNaN(regression.getSumSquaredErrors()));
        Assert.assertTrue((String)"predict not NaN", (boolean)Double.isNaN(regression.predict(0.0)));
        Assert.assertTrue((String)"SSTO NaN", (!Double.isNaN(regression.getTotalSumSquares()) ? 1 : 0) != 0);
        regression = new SimpleRegression();
        regression.addData(1.0, 2.0);
        regression.addData(3.0, 3.0);
        Assert.assertTrue((String)"interceptNaN", (!Double.isNaN(regression.getIntercept()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"slope NaN", (!Double.isNaN(regression.getSlope()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"slope std err not NaN", (boolean)Double.isNaN(regression.getSlopeStdErr()));
        Assert.assertTrue((String)"intercept std err not NaN", (boolean)Double.isNaN(regression.getInterceptStdErr()));
        Assert.assertTrue((String)"MSE not NaN", (boolean)Double.isNaN(regression.getMeanSquareError()));
        Assert.assertTrue((String)"r NaN", (!Double.isNaN(regression.getR()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"r-square NaN", (!Double.isNaN(regression.getRSquare()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"RSS NaN", (!Double.isNaN(regression.getRegressionSumSquares()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"SSE NaN", (!Double.isNaN(regression.getSumSquaredErrors()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"SSTO NaN", (!Double.isNaN(regression.getTotalSumSquares()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"predict NaN", (!Double.isNaN(regression.predict(0.0)) ? 1 : 0) != 0);
        regression.addData(1.0, 4.0);
        Assert.assertTrue((String)"MSE NaN", (!Double.isNaN(regression.getMeanSquareError()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"slope std err NaN", (!Double.isNaN(regression.getSlopeStdErr()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"intercept std err NaN", (!Double.isNaN(regression.getInterceptStdErr()) ? 1 : 0) != 0);
    }

    @Test
    public void testClear() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.corrData);
        Assert.assertEquals((String)"number of observations", (long)17L, (long)regression.getN());
        regression.clear();
        Assert.assertEquals((String)"number of observations", (long)0L, (long)regression.getN());
        regression.addData(this.corrData);
        Assert.assertEquals((String)"r-square", (double)0.896123, (double)regression.getRSquare(), (double)1.0E-5);
        regression.addData(this.data);
        Assert.assertEquals((String)"number of observations", (long)53L, (long)regression.getN());
    }

    @Test
    public void testInference() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.infData);
        Assert.assertEquals((String)"slope std err", (double)0.011448491, (double)regression.getSlopeStdErr(), (double)1.0E-10);
        Assert.assertEquals((String)"std err intercept", (double)0.286036932, (double)regression.getInterceptStdErr(), (double)1.0E-8);
        Assert.assertEquals((String)"significance", (double)4.596E-7, (double)regression.getSignificance(), (double)1.0E-8);
        Assert.assertEquals((String)"slope conf interval half-width", (double)0.0270713794287, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8);
        regression = new SimpleRegression();
        regression.addData(this.infData2);
        Assert.assertEquals((String)"slope std err", (double)1.07260253, (double)regression.getSlopeStdErr(), (double)1.0E-8);
        Assert.assertEquals((String)"std err intercept", (double)4.17718672, (double)regression.getInterceptStdErr(), (double)1.0E-8);
        Assert.assertEquals((String)"significance", (double)0.261829133982, (double)regression.getSignificance(), (double)1.0E-11);
        Assert.assertEquals((String)"slope conf interval half-width", (double)2.97802204827, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8);
        Assert.assertTrue((String)"tighter means wider", (regression.getSlopeConfidenceInterval() < regression.getSlopeConfidenceInterval(0.01) ? 1 : 0) != 0);
        try {
            regression.getSlopeConfidenceInterval(1.0);
            Assert.fail((String)"expecting MathIllegalArgumentException for alpha = 1");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPerfect() {
        SimpleRegression regression = new SimpleRegression();
        int n = 100;
        for (int i = 0; i < n; ++i) {
            regression.addData((double)i / (double)(n - 1), (double)i);
        }
        Assert.assertEquals((double)0.0, (double)regression.getSignificance(), (double)1.0E-5);
        Assert.assertTrue((regression.getSlope() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((regression.getSumSquaredErrors() >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerfect2() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(0.0, 0.0);
        regression.addData(1.0, 1.0);
        regression.addData(2.0, 2.0);
        Assert.assertEquals((double)0.0, (double)regression.getSlopeStdErr(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)regression.getSignificance(), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)regression.getRSquare(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testPerfectNegative() {
        SimpleRegression regression = new SimpleRegression();
        int n = 100;
        for (int i = 0; i < n; ++i) {
            regression.addData(-((double)i) / (double)(n - 1), (double)i);
        }
        Assert.assertEquals((double)0.0, (double)regression.getSignificance(), (double)1.0E-5);
        Assert.assertTrue((regression.getSlope() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testRandom() {
        SimpleRegression regression = new SimpleRegression();
        Random random = new Random(1L);
        int n = 100;
        for (int i = 0; i < n; ++i) {
            regression.addData((double)i / (double)(n - 1), random.nextDouble());
        }
        Assert.assertTrue((0.0 < regression.getSignificance() && regression.getSignificance() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSSENonNegative() {
        double[] y = new double[]{8915.102, 8919.302, 8923.502};
        double[] x = new double[]{110.7178495, 110.7264895, 110.7351295};
        SimpleRegression reg = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            reg.addData(x[i], y[i]);
        }
        Assert.assertTrue((reg.getSumSquaredErrors() >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveXY() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.infData);
        regression.removeData(this.removeX, this.removeY);
        regression.addData(this.removeX, this.removeY);
        Assert.assertEquals((String)"slope std err", (double)0.011448491, (double)regression.getSlopeStdErr(), (double)1.0E-10);
        Assert.assertEquals((String)"std err intercept", (double)0.286036932, (double)regression.getInterceptStdErr(), (double)1.0E-8);
        Assert.assertEquals((String)"significance", (double)4.596E-7, (double)regression.getSignificance(), (double)1.0E-8);
        Assert.assertEquals((String)"slope conf interval half-width", (double)0.0270713794287, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8);
    }

    @Test
    public void testRemoveSingle() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.infData);
        regression.removeData(this.removeSingle);
        regression.addData(this.removeSingle);
        Assert.assertEquals((String)"slope std err", (double)0.011448491, (double)regression.getSlopeStdErr(), (double)1.0E-10);
        Assert.assertEquals((String)"std err intercept", (double)0.286036932, (double)regression.getInterceptStdErr(), (double)1.0E-8);
        Assert.assertEquals((String)"significance", (double)4.596E-7, (double)regression.getSignificance(), (double)1.0E-8);
        Assert.assertEquals((String)"slope conf interval half-width", (double)0.0270713794287, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8);
    }

    @Test
    public void testRemoveMultiple() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.infData);
        regression.removeData(this.removeMultiple);
        regression.addData(this.removeMultiple);
        Assert.assertEquals((String)"slope std err", (double)0.011448491, (double)regression.getSlopeStdErr(), (double)1.0E-10);
        Assert.assertEquals((String)"std err intercept", (double)0.286036932, (double)regression.getInterceptStdErr(), (double)1.0E-8);
        Assert.assertEquals((String)"significance", (double)4.596E-7, (double)regression.getSignificance(), (double)1.0E-8);
        Assert.assertEquals((String)"slope conf interval half-width", (double)0.0270713794287, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8);
    }

    @Test
    public void testRemoveObsFromEmpty() {
        SimpleRegression regression = new SimpleRegression();
        regression.removeData(this.removeX, this.removeY);
        Assert.assertEquals((long)regression.getN(), (long)0L);
    }

    @Test
    public void testRemoveObsFromSingle() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.removeX, this.removeY);
        regression.removeData(this.removeX, this.removeY);
        Assert.assertEquals((long)regression.getN(), (long)0L);
    }

    @Test
    public void testRemoveMultipleToEmpty() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.removeMultiple);
        regression.removeData(this.removeMultiple);
        Assert.assertEquals((long)regression.getN(), (long)0L);
    }

    @Test
    public void testRemoveMultiplePastEmpty() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.removeX, this.removeY);
        regression.removeData(this.removeMultiple);
        Assert.assertEquals((long)regression.getN(), (long)0L);
    }
}

