/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.Mean;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.Variance;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.summary.Sum;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class SummaryStatisticsTest {
    private double one = 1.0;
    private float twoF = 2.0f;
    private long twoL = 2L;
    private int three = 3;
    private double mean = 2.0;
    private double sumSq = 18.0;
    private double sum = 8.0;
    private double var = 0.6666666666666666;
    private double popVar = 0.5;
    private double std = FastMath.sqrt((double)this.var);
    private double n = 4.0;
    private double min = 1.0;
    private double max = 3.0;
    private double tolerance = 1.0E-14;

    protected SummaryStatistics createSummaryStatistics() {
        return new SummaryStatistics();
    }

    @Test
    public void testStats() {
        SummaryStatistics u = this.createSummaryStatistics();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)this.tolerance);
        u.addValue(this.one);
        u.addValue((double)this.twoF);
        u.addValue((double)this.twoL);
        u.addValue((double)this.three);
        Assert.assertEquals((String)"N", (double)this.n, (double)u.getN(), (double)this.tolerance);
        Assert.assertEquals((String)"sum", (double)this.sum, (double)u.getSum(), (double)this.tolerance);
        Assert.assertEquals((String)"sumsq", (double)this.sumSq, (double)u.getSumsq(), (double)this.tolerance);
        Assert.assertEquals((String)"var", (double)this.var, (double)u.getVariance(), (double)this.tolerance);
        Assert.assertEquals((String)"population var", (double)this.popVar, (double)u.getPopulationVariance(), (double)this.tolerance);
        Assert.assertEquals((String)"std", (double)this.std, (double)u.getStandardDeviation(), (double)this.tolerance);
        Assert.assertEquals((String)"mean", (double)this.mean, (double)u.getMean(), (double)this.tolerance);
        Assert.assertEquals((String)"min", (double)this.min, (double)u.getMin(), (double)this.tolerance);
        Assert.assertEquals((String)"max", (double)this.max, (double)u.getMax(), (double)this.tolerance);
        u.clear();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)this.tolerance);
    }

    @Test
    public void testN0andN1Conditions() {
        SummaryStatistics u = this.createSummaryStatistics();
        Assert.assertTrue((String)"Mean of n = 0 set should be NaN", (boolean)Double.isNaN(u.getMean()));
        Assert.assertTrue((String)"Standard Deviation of n = 0 set should be NaN", (boolean)Double.isNaN(u.getStandardDeviation()));
        Assert.assertTrue((String)"Variance of n = 0 set should be NaN", (boolean)Double.isNaN(u.getVariance()));
        u.addValue(this.one);
        Assert.assertTrue((String)"mean should be one (n = 1)", (u.getMean() == this.one ? 1 : 0) != 0);
        Assert.assertTrue((String)("geometric should be one (n = 1) instead it is " + u.getGeometricMean()), (u.getGeometricMean() == this.one ? 1 : 0) != 0);
        Assert.assertTrue((String)"Std should be zero (n = 1)", (u.getStandardDeviation() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"variance should be zero (n = 1)", (u.getVariance() == 0.0 ? 1 : 0) != 0);
        u.addValue((double)this.twoF);
        Assert.assertTrue((String)"Std should not be zero (n = 2)", (u.getStandardDeviation() != 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"variance should not be zero (n = 2)", (u.getVariance() != 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testProductAndGeometricMean() {
        SummaryStatistics u = this.createSummaryStatistics();
        u.addValue(1.0);
        u.addValue(2.0);
        u.addValue(3.0);
        u.addValue(4.0);
        Assert.assertEquals((String)"Geometric mean not expected", (double)2.213364, (double)u.getGeometricMean(), (double)1.0E-5);
    }

    @Test
    public void testNaNContracts() {
        SummaryStatistics u = this.createSummaryStatistics();
        Assert.assertTrue((String)"mean not NaN", (boolean)Double.isNaN(u.getMean()));
        Assert.assertTrue((String)"min not NaN", (boolean)Double.isNaN(u.getMin()));
        Assert.assertTrue((String)"std dev not NaN", (boolean)Double.isNaN(u.getStandardDeviation()));
        Assert.assertTrue((String)"var not NaN", (boolean)Double.isNaN(u.getVariance()));
        Assert.assertTrue((String)"geom mean not NaN", (boolean)Double.isNaN(u.getGeometricMean()));
        u.addValue(1.0);
        Assert.assertEquals((String)"mean not expected", (double)1.0, (double)u.getMean(), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"variance not expected", (double)0.0, (double)u.getVariance(), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"geometric mean not expected", (double)1.0, (double)u.getGeometricMean(), (double)Double.MIN_VALUE);
        u.addValue(-1.0);
        Assert.assertTrue((String)"geom mean not NaN", (boolean)Double.isNaN(u.getGeometricMean()));
        u.addValue(0.0);
        Assert.assertTrue((String)"geom mean not NaN", (boolean)Double.isNaN(u.getGeometricMean()));
    }

    @Test
    public void testGetSummary() {
        SummaryStatistics u = this.createSummaryStatistics();
        StatisticalSummary summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(1.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
    }

    @Test
    public void testSerialization() {
        SummaryStatistics u = this.createSummaryStatistics();
        TestUtils.checkSerializedEquality(u);
        SummaryStatistics s = (SummaryStatistics)TestUtils.serializeAndRecover(u);
        StatisticalSummary summary = s.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        u.addValue(5.0);
        TestUtils.checkSerializedEquality(u);
        s = (SummaryStatistics)TestUtils.serializeAndRecover(u);
        summary = s.getSummary();
        this.verifySummary(u, summary);
    }

    @Test
    public void testEqualsAndHashCode() {
        SummaryStatistics u = this.createSummaryStatistics();
        SummaryStatistics t = null;
        int emptyHash = u.hashCode();
        Assert.assertTrue((String)"reflexive", (boolean)u.equals((Object)u));
        Assert.assertFalse((String)"non-null compared to null", (boolean)u.equals(t));
        Assert.assertFalse((String)"wrong type", (boolean)u.equals((Object)0.0));
        t = this.createSummaryStatistics();
        Assert.assertTrue((String)"empty instances should be equal", (boolean)t.equals((Object)u));
        Assert.assertTrue((String)"empty instances should be equal", (boolean)u.equals((Object)t));
        Assert.assertEquals((String)"empty hash code", (long)emptyHash, (long)t.hashCode());
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        Assert.assertFalse((String)"different n's should make instances not equal", (boolean)t.equals((Object)u));
        Assert.assertFalse((String)"different n's should make instances not equal", (boolean)u.equals((Object)t));
        Assert.assertTrue((String)"different n's should make hashcodes different", (u.hashCode() != t.hashCode() ? 1 : 0) != 0);
        t.addValue(2.0);
        t.addValue(1.0);
        t.addValue(3.0);
        t.addValue(4.0);
        Assert.assertTrue((String)"summaries based on same data should be equal", (boolean)t.equals((Object)u));
        Assert.assertTrue((String)"summaries based on same data should be equal", (boolean)u.equals((Object)t));
        Assert.assertEquals((String)"summaries based on same data should have same hashcodes", (long)u.hashCode(), (long)t.hashCode());
        u.clear();
        t.clear();
        Assert.assertTrue((String)"empty instances should be equal", (boolean)t.equals((Object)u));
        Assert.assertTrue((String)"empty instances should be equal", (boolean)u.equals((Object)t));
        Assert.assertEquals((String)"empty hash code", (long)emptyHash, (long)t.hashCode());
        Assert.assertEquals((String)"empty hash code", (long)emptyHash, (long)u.hashCode());
    }

    @Test
    public void testCopy() {
        SummaryStatistics u = this.createSummaryStatistics();
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        SummaryStatistics v = new SummaryStatistics(u);
        Assert.assertEquals((Object)u, (Object)v);
        Assert.assertEquals((Object)v, (Object)u);
        u.addValue(7.0);
        u.addValue(9.0);
        u.addValue(11.0);
        u.addValue(23.0);
        v.addValue(7.0);
        v.addValue(9.0);
        v.addValue(11.0);
        v.addValue(23.0);
        Assert.assertEquals((Object)u, (Object)v);
        Assert.assertEquals((Object)v, (Object)u);
        u.clear();
        u.setSumImpl((StorelessUnivariateStatistic)new Sum());
        SummaryStatistics.copy((SummaryStatistics)u, (SummaryStatistics)v);
        Assert.assertEquals((Object)u.getSumImpl(), (Object)v.getSumImpl());
    }

    private void verifySummary(SummaryStatistics u, StatisticalSummary s) {
        Assert.assertEquals((String)"N", (long)s.getN(), (long)u.getN());
        TestUtils.assertEquals("sum", s.getSum(), u.getSum(), this.tolerance);
        TestUtils.assertEquals("var", s.getVariance(), u.getVariance(), this.tolerance);
        TestUtils.assertEquals("std", s.getStandardDeviation(), u.getStandardDeviation(), this.tolerance);
        TestUtils.assertEquals("mean", s.getMean(), u.getMean(), this.tolerance);
        TestUtils.assertEquals("min", s.getMin(), u.getMin(), this.tolerance);
        TestUtils.assertEquals("max", s.getMax(), u.getMax(), this.tolerance);
    }

    @Test
    public void testSetterInjection() {
        SummaryStatistics u = this.createSummaryStatistics();
        u.setMeanImpl((StorelessUnivariateStatistic)new Sum());
        u.setSumLogImpl((StorelessUnivariateStatistic)new Sum());
        u.addValue(1.0);
        u.addValue(3.0);
        Assert.assertEquals((double)4.0, (double)u.getMean(), (double)1.0E-14);
        Assert.assertEquals((double)4.0, (double)u.getSumOfLogs(), (double)1.0E-14);
        Assert.assertEquals((double)FastMath.exp((double)2.0), (double)u.getGeometricMean(), (double)1.0E-14);
        u.clear();
        u.addValue(1.0);
        u.addValue(2.0);
        Assert.assertEquals((double)3.0, (double)u.getMean(), (double)1.0E-14);
        u.clear();
        u.setMeanImpl((StorelessUnivariateStatistic)new Mean());
    }

    @Test
    public void testSetterIllegalState() {
        SummaryStatistics u = this.createSummaryStatistics();
        u.addValue(1.0);
        u.addValue(3.0);
        try {
            u.setMeanImpl((StorelessUnivariateStatistic)new Sum());
            Assert.fail((String)"Expecting IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testQuadraticMean() {
        double[] values = new double[]{1.2, 3.4, 5.6, 7.89};
        SummaryStatistics stats = this.createSummaryStatistics();
        int len = values.length;
        double expected = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = values[i];
            expected += v * v / (double)len;
            stats.addValue(v);
        }
        expected = Math.sqrt(expected);
        Assert.assertEquals((double)expected, (double)stats.getQuadraticMean(), (double)Math.ulp(expected));
    }

    @Test
    public void testOverrideVarianceWithMathClass() {
        double[] scores = new double[]{1.0, 2.0, 3.0, 4.0};
        SummaryStatistics stats = new SummaryStatistics();
        stats.setVarianceImpl((StorelessUnivariateStatistic)new Variance(false));
        for (double i : scores) {
            stats.addValue(i);
        }
        Assert.assertEquals((double)new Variance(false).evaluate(scores), (double)stats.getVariance(), (double)0.0);
    }

    @Test
    public void testOverrideMeanWithMathClass() {
        double[] scores = new double[]{1.0, 2.0, 3.0, 4.0};
        SummaryStatistics stats = new SummaryStatistics();
        stats.setMeanImpl((StorelessUnivariateStatistic)new Mean());
        for (double i : scores) {
            stats.addValue(i);
        }
        Assert.assertEquals((double)new Mean().evaluate(scores), (double)stats.getMean(), (double)0.0);
    }

    @Test
    public void testOverrideGeoMeanWithMathClass() {
        double[] scores = new double[]{1.0, 2.0, 3.0, 4.0};
        SummaryStatistics stats = new SummaryStatistics();
        stats.setGeoMeanImpl((StorelessUnivariateStatistic)new GeometricMean());
        for (double i : scores) {
            stats.addValue(i);
        }
        Assert.assertEquals((double)new GeometricMean().evaluate(scores), (double)stats.getGeometricMean(), (double)0.0);
    }

    @Test
    public void testToString() {
        SummaryStatistics u = this.createSummaryStatistics();
        for (int i = 0; i < 5; ++i) {
            u.addValue((double)i);
        }
        String[] labels = new String[]{"min", "max", "sum", "geometric mean", "variance", "population variance", "second moment", "sum of squares", "standard deviation", "sum of logs"};
        double[] values = new double[]{u.getMin(), u.getMax(), u.getSum(), u.getGeometricMean(), u.getVariance(), u.getPopulationVariance(), u.getSecondMoment(), u.getSumsq(), u.getStandardDeviation(), u.getSumOfLogs()};
        String toString = u.toString();
        Assert.assertTrue((toString.indexOf("n: " + u.getN()) > 0 ? 1 : 0) != 0);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertTrue((toString.indexOf(labels[i] + ": " + String.valueOf(values[i])) > 0 ? 1 : 0) != 0);
        }
    }
}

