/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.random;

import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.random.SobolSequenceGenerator;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SobolSequenceGeneratorTest {
    private double[][] referenceValues = new double[][]{{0.0, 0.0, 0.0}, {0.5, 0.5, 0.5}, {0.75, 0.25, 0.25}, {0.25, 0.75, 0.75}, {0.375, 0.375, 0.625}, {0.875, 0.875, 0.125}, {0.625, 0.125, 0.875}, {0.125, 0.625, 0.375}, {0.1875, 0.3125, 0.9375}, {0.6875, 0.8125, 0.4375}};
    private SobolSequenceGenerator generator;

    @Before
    public void setUp() {
        this.generator = new SobolSequenceGenerator(3);
    }

    @Test
    public void test3DReference() {
        for (int i = 0; i < this.referenceValues.length; ++i) {
            double[] result = this.generator.nextVector();
            Assert.assertArrayEquals((double[])this.referenceValues[i], (double[])result, (double)1.0E-6);
            Assert.assertEquals((long)(i + 1), (long)this.generator.getNextIndex());
        }
    }

    @Test
    public void testConstructor() {
        try {
            new SobolSequenceGenerator(0);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            new SobolSequenceGenerator(1001);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructor2() throws Exception {
        try {
            String RESOURCE_NAME = "/assets/org/apache/commons/math3/random/new-joe-kuo-6.1000";
            InputStream is = this.getClass().getResourceAsStream("/assets/org/apache/commons/math3/random/new-joe-kuo-6.1000");
            new SobolSequenceGenerator(1001, is);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            new SobolSequenceGenerator(1001);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSkip() {
        double[] result = this.generator.skipTo(5);
        Assert.assertArrayEquals((double[])this.referenceValues[5], (double[])result, (double)1.0E-6);
        Assert.assertEquals((long)6L, (long)this.generator.getNextIndex());
        for (int i = 6; i < this.referenceValues.length; ++i) {
            result = this.generator.nextVector();
            Assert.assertArrayEquals((double[])this.referenceValues[i], (double[])result, (double)1.0E-6);
            Assert.assertEquals((long)(i + 1), (long)this.generator.getNextIndex());
        }
    }
}

