/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.random;

import com.hazelcast.shaded.org.apache.commons.math3.Retry;
import com.hazelcast.shaded.org.apache.commons.math3.RetryRunner;
import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.BetaDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.BinomialDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.BinomialDistributionTest;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.CauchyDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.ChiSquaredDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.ExponentialDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.FDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.GammaDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.HypergeometricDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.HypergeometricDistributionTest;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.NormalDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.PascalDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.PascalDistributionTest;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.PoissonDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.TDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.WeibullDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.ZipfDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.ZipfDistributionTest;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomDataGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.stat.Frequency;
import com.hazelcast.shaded.org.apache.commons.math3.stat.inference.ChiSquareTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RetryRunner.class)
public class RandomDataGeneratorTest {
    protected final long smallSampleSize = 1000L;
    protected final double[] expected = new double[]{250.0, 250.0, 250.0, 250.0};
    protected final int largeSampleSize = 10000;
    private final String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    protected RandomDataGenerator randomData = null;
    protected final ChiSquareTest testStatistic = new ChiSquareTest();

    public RandomDataGeneratorTest() {
        this.randomData = new RandomDataGenerator();
        this.randomData.reSeed(1000L);
    }

    @Test
    public void testNextIntExtremeValues() {
        int y;
        int x = this.randomData.nextInt(Integer.MIN_VALUE, Integer.MAX_VALUE);
        Assert.assertFalse((x == (y = this.randomData.nextInt(Integer.MIN_VALUE, Integer.MAX_VALUE)) ? 1 : 0) != 0);
    }

    @Test
    public void testNextLongExtremeValues() {
        long y;
        long x = this.randomData.nextLong(Long.MIN_VALUE, Long.MAX_VALUE);
        Assert.assertFalse((x == (y = this.randomData.nextLong(Long.MIN_VALUE, Long.MAX_VALUE)) ? 1 : 0) != 0);
    }

    @Test
    public void testNextUniformExtremeValues() {
        double y;
        double x = this.randomData.nextUniform(-1.7976931348623157E308, Double.MAX_VALUE);
        Assert.assertFalse((x == (y = this.randomData.nextUniform(-1.7976931348623157E308, Double.MAX_VALUE)) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)Double.isNaN(x));
        Assert.assertFalse((boolean)Double.isNaN(y));
        Assert.assertFalse((boolean)Double.isInfinite(x));
        Assert.assertFalse((boolean)Double.isInfinite(y));
    }

    @Test
    public void testNextIntIAE() {
        try {
            this.randomData.nextInt(4, 3);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNextIntNegativeToPositiveRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextIntUniform(-3, 5);
            this.checkNextIntUniform(-3, 6);
        }
    }

    @Test
    public void testNextIntNegativeRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextIntUniform(-7, -4);
            this.checkNextIntUniform(-15, -2);
            this.checkNextIntUniform(-2147483647, -2147483636);
        }
    }

    @Test
    public void testNextIntPositiveRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextIntUniform(0, 3);
            this.checkNextIntUniform(2, 12);
            this.checkNextIntUniform(1, 2);
            this.checkNextIntUniform(0x7FFFFFF3, 0x7FFFFFFE);
        }
    }

    private void checkNextIntUniform(int min, int max) {
        Frequency freq = new Frequency();
        int i = 0;
        while ((long)i < 1000L) {
            int value = this.randomData.nextInt(min, max);
            Assert.assertTrue((String)"nextInt range", (value >= min && value <= max ? 1 : 0) != 0);
            freq.addValue(value);
            ++i;
        }
        int len = max - min + 1;
        long[] observed = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            observed[i2] = freq.getCount(min + i2);
        }
        double[] expected = new double[len];
        for (int i3 = 0; i3 < len; ++i3) {
            expected[i3] = 1.0 / (double)len;
        }
        TestUtils.assertChiSquareAccept(expected, observed, 0.001);
    }

    @Test
    public void testNextIntWideRange() {
        int lower = -1698898191;
        int upper = 1164413355;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < 1000000; ++i) {
            int r = this.randomData.nextInt(lower, upper);
            max = FastMath.max((int)max, (int)r);
            min = FastMath.min((int)min, (int)r);
            Assert.assertTrue((r >= lower ? 1 : 0) != 0);
            Assert.assertTrue((r <= upper ? 1 : 0) != 0);
        }
        double ratio = ((double)max - (double)min) / ((double)upper - (double)lower);
        Assert.assertTrue((ratio > 0.99999 ? 1 : 0) != 0);
    }

    @Test
    public void testNextLongIAE() {
        try {
            this.randomData.nextLong(4L, 3L);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNextLongNegativeToPositiveRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextLongUniform(-3L, 5L);
            this.checkNextLongUniform(-3L, 6L);
        }
    }

    @Test
    public void testNextLongNegativeRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextLongUniform(-7L, -4L);
            this.checkNextLongUniform(-15L, -2L);
            this.checkNextLongUniform(-9223372036854775807L, -9223372036854775796L);
        }
    }

    @Test
    public void testNextLongPositiveRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextLongUniform(0L, 3L);
            this.checkNextLongUniform(2L, 12L);
            this.checkNextLongUniform(0x7FFFFFFFFFFFFFF3L, 0x7FFFFFFFFFFFFFFEL);
        }
    }

    private void checkNextLongUniform(long min, long max) {
        Frequency freq = new Frequency();
        int i = 0;
        while ((long)i < 1000L) {
            long value = this.randomData.nextLong(min, max);
            Assert.assertTrue((String)("nextLong range: " + value + " " + min + " " + max), (value >= min && value <= max ? 1 : 0) != 0);
            freq.addValue(value);
            ++i;
        }
        int len = (int)(max - min) + 1;
        long[] observed = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            observed[i2] = freq.getCount(min + (long)i2);
        }
        double[] expected = new double[len];
        for (int i3 = 0; i3 < len; ++i3) {
            expected[i3] = 1.0 / (double)len;
        }
        TestUtils.assertChiSquareAccept(expected, observed, 0.01);
    }

    @Test
    public void testNextLongWideRange() {
        long lower = -7296712173568108935L;
        long upper = 5001117282205630755L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < 10000000; ++i) {
            long r = this.randomData.nextLong(lower, upper);
            max = FastMath.max((long)max, (long)r);
            min = FastMath.min((long)min, (long)r);
            Assert.assertTrue((r >= lower ? 1 : 0) != 0);
            Assert.assertTrue((r <= upper ? 1 : 0) != 0);
        }
        double ratio = ((double)max - (double)min) / ((double)upper - (double)lower);
        Assert.assertTrue((ratio > 0.99999 ? 1 : 0) != 0);
    }

    @Test
    public void testNextSecureLongIAE() {
        try {
            this.randomData.nextSecureLong(4L, 3L);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Retry(value=3)
    public void testNextSecureLongNegativeToPositiveRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextSecureLongUniform(-3, 5);
            this.checkNextSecureLongUniform(-3, 6);
        }
    }

    @Test
    @Retry(value=3)
    public void testNextSecureLongNegativeRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextSecureLongUniform(-7, -4);
            this.checkNextSecureLongUniform(-15, -2);
        }
    }

    @Test
    @Retry(value=3)
    public void testNextSecureLongPositiveRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextSecureLongUniform(0, 3);
            this.checkNextSecureLongUniform(2, 12);
        }
    }

    private void checkNextSecureLongUniform(int min, int max) {
        Frequency freq = new Frequency();
        int i = 0;
        while ((long)i < 1000L) {
            long value = this.randomData.nextSecureLong((long)min, (long)max);
            Assert.assertTrue((String)"nextLong range", (value >= (long)min && value <= (long)max ? 1 : 0) != 0);
            freq.addValue(value);
            ++i;
        }
        int len = max - min + 1;
        long[] observed = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            observed[i2] = freq.getCount(min + i2);
        }
        double[] expected = new double[len];
        for (int i3 = 0; i3 < len; ++i3) {
            expected[i3] = 1.0 / (double)len;
        }
        TestUtils.assertChiSquareAccept(expected, observed, 1.0E-4);
    }

    @Test
    public void testNextSecureIntIAE() {
        try {
            this.randomData.nextSecureInt(4, 3);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Retry(value=3)
    public void testNextSecureIntNegativeToPositiveRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextSecureIntUniform(-3, 5);
            this.checkNextSecureIntUniform(-3, 6);
        }
    }

    @Test
    @Retry(value=3)
    public void testNextSecureIntNegativeRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextSecureIntUniform(-7, -4);
            this.checkNextSecureIntUniform(-15, -2);
        }
    }

    @Test
    @Retry(value=3)
    public void testNextSecureIntPositiveRange() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextSecureIntUniform(0, 3);
            this.checkNextSecureIntUniform(2, 12);
        }
    }

    private void checkNextSecureIntUniform(int min, int max) {
        Frequency freq = new Frequency();
        int i = 0;
        while ((long)i < 1000L) {
            int value = this.randomData.nextSecureInt(min, max);
            Assert.assertTrue((String)"nextInt range", (value >= min && value <= max ? 1 : 0) != 0);
            freq.addValue(value);
            ++i;
        }
        int len = max - min + 1;
        long[] observed = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            observed[i2] = freq.getCount(min + i2);
        }
        double[] expected = new double[len];
        for (int i3 = 0; i3 < len; ++i3) {
            expected[i3] = 1.0 / (double)len;
        }
        TestUtils.assertChiSquareAccept(expected, observed, 1.0E-4);
    }

    @Test
    public void testNextPoisson() {
        try {
            this.randomData.nextPoisson(0.0);
            Assert.fail((String)"zero mean -- expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextPoisson(-1.0);
            Assert.fail((String)"negative mean supplied -- MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextPoisson(0.0);
            Assert.fail((String)"0 mean supplied -- MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double mean = 4.0;
        int len = 5;
        PoissonDistribution poissonDistribution = new PoissonDistribution(4.0);
        Frequency f = new Frequency();
        this.randomData.reSeed(1000L);
        for (int i = 0; i < 10000; ++i) {
            f.addValue(this.randomData.nextPoisson(4.0));
        }
        long[] observed = new long[5];
        for (int i = 0; i < 5; ++i) {
            observed[i] = f.getCount(i + 1);
        }
        double[] expected = new double[5];
        for (int i = 0; i < 5; ++i) {
            expected[i] = poissonDistribution.probability(i + 1) * 10000.0;
        }
        TestUtils.assertChiSquareAccept(expected, observed, 1.0E-4);
    }

    @Test
    public void testNextPoissonConsistency() {
        int i;
        for (i = 1; i < 100; ++i) {
            this.checkNextPoissonConsistency(i);
        }
        for (i = 1; i < 10; ++i) {
            this.checkNextPoissonConsistency(this.randomData.nextUniform(1.0, 1000.0));
        }
        for (i = 1; i < 10; ++i) {
            this.checkNextPoissonConsistency(this.randomData.nextUniform(1000.0, 10000.0));
        }
    }

    public void checkNextPoissonConsistency(double mean) {
        int i;
        int sampleSize = 1000;
        int minExpectedCount = 7;
        long maxObservedValue = 0L;
        double alpha = 0.001;
        Frequency frequency = new Frequency();
        for (int i2 = 0; i2 < 1000; ++i2) {
            long value = this.randomData.nextPoisson(mean);
            if (value > maxObservedValue) {
                maxObservedValue = value;
            }
            frequency.addValue(value);
        }
        PoissonDistribution poissonDistribution = new PoissonDistribution(mean);
        int lower = 1;
        while (poissonDistribution.cumulativeProbability(lower - 1) * 1000.0 < 7.0) {
            ++lower;
        }
        int upper = (int)(5.0 * mean);
        while ((1.0 - poissonDistribution.cumulativeProbability(upper - 1)) * 1000.0 < 7.0) {
            --upper;
        }
        int binWidth = 0;
        boolean widthSufficient = false;
        double lowerBinMass = 0.0;
        double upperBinMass = 0.0;
        while (!widthSufficient) {
            widthSufficient = FastMath.min((double)(lowerBinMass = poissonDistribution.cumulativeProbability(lower - 1, lower + ++binWidth - 1)), (double)(upperBinMass = poissonDistribution.cumulativeProbability(upper - binWidth - 1, upper - 1))) * 1000.0 >= 7.0;
        }
        ArrayList<Integer> binBounds = new ArrayList<Integer>();
        binBounds.add(lower);
        for (int bound = lower + binWidth; bound < upper - binWidth; bound += binWidth) {
            binBounds.add(bound);
        }
        binBounds.add(upper);
        int binCount = binBounds.size() + 1;
        long[] observed = new long[binCount];
        double[] expected = new double[binCount];
        observed[0] = 0L;
        for (i = 0; i < lower; ++i) {
            observed[0] = observed[0] + frequency.getCount(i);
        }
        expected[0] = poissonDistribution.cumulativeProbability(lower - 1) * 1000.0;
        observed[binCount - 1] = 0L;
        i = upper;
        while ((long)i <= maxObservedValue) {
            int n = binCount - 1;
            observed[n] = observed[n] + frequency.getCount(i);
            ++i;
        }
        expected[binCount - 1] = (1.0 - poissonDistribution.cumulativeProbability(upper - 1)) * 1000.0;
        for (i = 1; i < binCount - 1; ++i) {
            observed[i] = 0L;
            for (int j = ((Integer)binBounds.get(i - 1)).intValue(); j < (Integer)binBounds.get(i); ++j) {
                int n = i;
                observed[n] = observed[n] + frequency.getCount(j);
            }
            expected[i] = (poissonDistribution.cumulativeProbability((Integer)binBounds.get(i) - 1) - poissonDistribution.cumulativeProbability((Integer)binBounds.get(i - 1) - 1)) * 1000.0;
        }
        ChiSquareTest chiSquareTest = new ChiSquareTest();
        if (chiSquareTest.chiSquareTest(expected, observed, 0.001)) {
            StringBuilder msgBuffer = new StringBuilder();
            DecimalFormat df = new DecimalFormat("#.##");
            msgBuffer.append("Chisquare test failed for mean = ");
            msgBuffer.append(mean);
            msgBuffer.append(" p-value = ");
            msgBuffer.append(chiSquareTest.chiSquareTest(expected, observed));
            msgBuffer.append(" chisquare statistic = ");
            msgBuffer.append(chiSquareTest.chiSquare(expected, observed));
            msgBuffer.append(". \n");
            msgBuffer.append("bin\t\texpected\tobserved\n");
            for (int i3 = 0; i3 < expected.length; ++i3) {
                msgBuffer.append("[");
                msgBuffer.append(i3 == 0 ? 1 : (Integer)binBounds.get(i3 - 1));
                msgBuffer.append(",");
                msgBuffer.append(i3 == binBounds.size() ? "inf" : (Serializable)binBounds.get(i3));
                msgBuffer.append(")");
                msgBuffer.append("\t\t");
                msgBuffer.append(df.format(expected[i3]));
                msgBuffer.append("\t\t");
                msgBuffer.append(observed[i3]);
                msgBuffer.append("\n");
            }
            msgBuffer.append("This test can fail randomly due to sampling error with probability ");
            msgBuffer.append(0.001);
            msgBuffer.append(".");
            Assert.fail((String)msgBuffer.toString());
        }
    }

    @Test
    public void testNextHex() {
        try {
            this.randomData.nextHexString(-1);
            Assert.fail((String)"negative length supplied -- MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextHexString(0);
            Assert.fail((String)"zero length supplied -- MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        String hexString = this.randomData.nextHexString(3);
        if (hexString.length() != 3) {
            Assert.fail((String)"incorrect length for generated string");
        }
        if ((hexString = this.randomData.nextHexString(1)).length() != 1) {
            Assert.fail((String)"incorrect length for generated string");
        }
        try {
            hexString = this.randomData.nextHexString(0);
            Assert.fail((String)"zero length requested -- expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Frequency f = new Frequency();
        int i = 0;
        while ((long)i < 1000L) {
            hexString = this.randomData.nextHexString(100);
            if (hexString.length() != 100) {
                Assert.fail((String)"incorrect length for generated string");
            }
            for (int j = 0; j < hexString.length(); ++j) {
                f.addValue((Comparable)((Object)hexString.substring(j, j + 1)));
            }
            ++i;
        }
        double[] expected = new double[16];
        long[] observed = new long[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            expected[i2] = 6250.0;
            observed[i2] = f.getCount((Comparable)((Object)this.hex[i2]));
        }
        TestUtils.assertChiSquareAccept(expected, observed, 0.001);
    }

    @Test
    @Retry(value=3)
    public void testNextSecureHex() {
        try {
            this.randomData.nextSecureHexString(-1);
            Assert.fail((String)"negative length -- MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextSecureHexString(0);
            Assert.fail((String)"zero length -- MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        String hexString = this.randomData.nextSecureHexString(3);
        if (hexString.length() != 3) {
            Assert.fail((String)"incorrect length for generated string");
        }
        if ((hexString = this.randomData.nextSecureHexString(1)).length() != 1) {
            Assert.fail((String)"incorrect length for generated string");
        }
        try {
            hexString = this.randomData.nextSecureHexString(0);
            Assert.fail((String)"zero length requested -- expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Frequency f = new Frequency();
        int i = 0;
        while ((long)i < 1000L) {
            hexString = this.randomData.nextSecureHexString(100);
            if (hexString.length() != 100) {
                Assert.fail((String)"incorrect length for generated string");
            }
            for (int j = 0; j < hexString.length(); ++j) {
                f.addValue((Comparable)((Object)hexString.substring(j, j + 1)));
            }
            ++i;
        }
        double[] expected = new double[16];
        long[] observed = new long[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            expected[i2] = 6250.0;
            observed[i2] = f.getCount((Comparable)((Object)this.hex[i2]));
        }
        TestUtils.assertChiSquareAccept(expected, observed, 0.001);
    }

    @Test
    public void testNextUniformIAE() {
        try {
            this.randomData.nextUniform(4.0, 3.0);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextUniform(0.0, Double.POSITIVE_INFINITY);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextUniform(Double.NEGATIVE_INFINITY, 0.0);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextUniform(0.0, Double.NaN);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextUniform(Double.NaN, 0.0);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNextUniformUniformPositiveBounds() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextUniformUniform(0.0, 10.0);
        }
    }

    @Test
    public void testNextUniformUniformNegativeToPositiveBounds() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextUniformUniform(-3.0, 5.0);
        }
    }

    @Test
    public void testNextUniformUniformNegaiveBounds() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextUniformUniform(-7.0, -3.0);
        }
    }

    @Test
    public void testNextUniformUniformMaximalInterval() {
        for (int i = 0; i < 5; ++i) {
            this.checkNextUniformUniform(-1.7976931348623157E308, Double.MAX_VALUE);
        }
    }

    private void checkNextUniformUniform(double min, double max) {
        int binCount = 5;
        double binSize = max / 5.0 - min / 5.0;
        double[] binBounds = new double[4];
        binBounds[0] = min + binSize;
        for (int i = 1; i < 4; ++i) {
            binBounds[i] = binBounds[i - 1] + binSize;
        }
        Frequency freq = new Frequency();
        int i = 0;
        while ((long)i < 1000L) {
            int j;
            double value = this.randomData.nextUniform(min, max);
            Assert.assertTrue((String)"nextUniform range", (value > min && value < max ? 1 : 0) != 0);
            for (j = 0; j < 4 && value > binBounds[j]; ++j) {
            }
            freq.addValue(j);
            ++i;
        }
        long[] observed = new long[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            observed[i2] = freq.getCount(i2);
        }
        double[] expected = new double[5];
        for (int i3 = 0; i3 < 5; ++i3) {
            expected[i3] = 0.2;
        }
        TestUtils.assertChiSquareAccept(expected, observed, 0.01);
    }

    @Test
    public void testNextUniformExclusiveEndpoints() {
        for (int i = 0; i < 1000; ++i) {
            double u = this.randomData.nextUniform(0.99, 1.0);
            Assert.assertTrue((u > 0.99 && u < 1.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNextGaussian() {
        try {
            this.randomData.nextGaussian(0.0, 0.0);
            Assert.fail((String)"zero sigma -- MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new NormalDistribution(0.0, 1.0));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (int i = 0; i < 1000; ++i) {
            double value = this.randomData.nextGaussian(0.0, 1.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testNextExponential() {
        double value;
        int i;
        try {
            this.randomData.nextExponential(-1.0);
            Assert.fail((String)"negative mean -- expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.randomData.nextExponential(0.0);
            Assert.fail((String)"zero mean -- expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new ExponentialDistribution(1.0));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (i = 0; i < 1000; ++i) {
            value = this.randomData.nextExponential(1.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
        quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new ExponentialDistribution(5.0));
        counts = new long[4];
        this.randomData.reSeed(1000L);
        for (i = 0; i < 1000; ++i) {
            value = this.randomData.nextExponential(5.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testConfig() {
        this.randomData.reSeed(1000L);
        double v = this.randomData.nextUniform(0.0, 1.0);
        this.randomData.reSeed();
        Assert.assertTrue((String)"different seeds", (FastMath.abs((double)(v - this.randomData.nextUniform(0.0, 1.0))) > 1.0E-11 ? 1 : 0) != 0);
        this.randomData.reSeed(1000L);
        Assert.assertEquals((String)"same seeds", (double)v, (double)this.randomData.nextUniform(0.0, 1.0), (double)1.0E-11);
        this.randomData.reSeedSecure(1000L);
        String hex = this.randomData.nextSecureHexString(40);
        this.randomData.reSeedSecure();
        Assert.assertTrue((String)"different seeds", (!hex.equals(this.randomData.nextSecureHexString(40)) ? 1 : 0) != 0);
        this.randomData.reSeedSecure(1000L);
        Assert.assertTrue((String)"same seeds", (!hex.equals(this.randomData.nextSecureHexString(40)) ? 1 : 0) != 0);
        RandomDataGenerator rd = new RandomDataGenerator();
        rd.reSeed(100L);
        rd.nextLong(1L, 2L);
        RandomDataGenerator rd2 = new RandomDataGenerator();
        rd2.reSeedSecure(2000L);
        rd2.nextSecureLong(1L, 2L);
        rd = new RandomDataGenerator();
        rd.reSeed();
        rd.nextLong(1L, 2L);
        rd2 = new RandomDataGenerator();
        rd2.reSeedSecure();
        rd2.nextSecureLong(1L, 2L);
    }

    @Test
    public void testNextSample() {
        int i;
        Object[][] c = new Object[][]{{"0", "1"}, {"0", "2"}, {"0", "3"}, {"0", "4"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"2", "3"}, {"2", "4"}, {"3", "4"}};
        long[] observed = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        double[] expected = new double[]{100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0};
        HashSet<String> cPop = new HashSet<String>();
        for (int i2 = 0; i2 < 5; ++i2) {
            cPop.add(Integer.toString(i2));
        }
        Object[] sets = new Object[10];
        for (i = 0; i < 10; ++i) {
            HashSet<Object> hs = new HashSet<Object>();
            hs.add(c[i][0]);
            hs.add(c[i][1]);
            sets[i] = hs;
        }
        for (i = 0; i < 1000; ++i) {
            Object[] cSamp = this.randomData.nextSample(cPop, 2);
            int n = this.findSample(sets, cSamp);
            observed[n] = observed[n] + 1L;
        }
        Assert.assertTrue((String)"chi-square test -- will fail about 1 in 1000 times", (this.testStatistic.chiSquare(expected, observed) < 27.88 ? 1 : 0) != 0);
        HashSet<String> hs = new HashSet<String>();
        hs.add("one");
        Object[] one = this.randomData.nextSample(hs, 1);
        String oneString = (String)one[0];
        if (one.length != 1 || !oneString.equals("one")) {
            Assert.fail((String)"bad sample for set size = 1, sample size = 1");
        }
        try {
            one = this.randomData.nextSample(hs, 2);
            Assert.fail((String)"sample size > set size, expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            hs = new HashSet();
            one = this.randomData.nextSample(hs, 0);
            Assert.fail((String)"n = k = 0, expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    private int findSample(Object[] u, Object[] samp) {
        for (int i = 0; i < u.length; ++i) {
            HashSet set = (HashSet)u[i];
            HashSet<Object> sampSet = new HashSet<Object>();
            for (int j = 0; j < samp.length; ++j) {
                sampSet.add(samp[j]);
            }
            if (!set.equals(sampSet)) continue;
            return i;
        }
        Assert.fail((String)("sample not found:{" + samp[0] + "," + samp[1] + "}"));
        return -1;
    }

    @Test
    public void testNextPermutation() {
        int[] perm;
        int[][] p = new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 0, 2}, {1, 2, 0}, {2, 0, 1}, {2, 1, 0}};
        long[] observed = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
        double[] expected = new double[]{100.0, 100.0, 100.0, 100.0, 100.0, 100.0};
        for (int i = 0; i < 600; ++i) {
            perm = this.randomData.nextPermutation(3, 3);
            int n = this.findPerm(p, perm);
            observed[n] = observed[n] + 1L;
        }
        String[] labels = new String[]{"{0, 1, 2}", "{ 0, 2, 1 }", "{ 1, 0, 2 }", "{ 1, 2, 0 }", "{ 2, 0, 1 }", "{ 2, 1, 0 }"};
        TestUtils.assertChiSquareAccept(labels, expected, observed, 0.001);
        perm = this.randomData.nextPermutation(1, 1);
        if (perm.length != 1 || perm[0] != 0) {
            Assert.fail((String)"bad permutation for n = 1, sample k = 1");
            try {
                perm = this.randomData.nextPermutation(2, 3);
                Assert.fail((String)"permutation k > n, expecting MathIllegalArgumentException");
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
            try {
                perm = this.randomData.nextPermutation(0, 0);
                Assert.fail((String)"permutation k = n = 0, expecting MathIllegalArgumentException");
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
            try {
                perm = this.randomData.nextPermutation(-1, -3);
                Assert.fail((String)"permutation k < n < 0, expecting MathIllegalArgumentException");
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
        }
    }

    private int findPerm(int[][] p, int[] samp) {
        for (int i = 0; i < p.length; ++i) {
            boolean good = true;
            for (int j = 0; j < samp.length; ++j) {
                if (samp[j] == p[i][j]) continue;
                good = false;
            }
            if (!good) continue;
            return i;
        }
        Assert.fail((String)"permutation not found");
        return -1;
    }

    @Test
    public void testNextBeta() {
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new BetaDistribution(2.0, 5.0));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (int i = 0; i < 1000; ++i) {
            double value = this.randomData.nextBeta(2.0, 5.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testNextCauchy() {
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new CauchyDistribution(1.2, 2.1));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (int i = 0; i < 1000; ++i) {
            double value = this.randomData.nextCauchy(1.2, 2.1);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testNextChiSquare() {
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new ChiSquaredDistribution(12.0));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (int i = 0; i < 1000; ++i) {
            double value = this.randomData.nextChiSquare(12.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testNextF() {
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new FDistribution(12.0, 5.0));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (int i = 0; i < 1000; ++i) {
            double value = this.randomData.nextF(12.0, 5.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testNextGamma() {
        double value;
        int i;
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new GammaDistribution(4.0, 2.0));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (i = 0; i < 1000; ++i) {
            value = this.randomData.nextGamma(4.0, 2.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
        quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new GammaDistribution(0.3, 3.0));
        counts = new long[4];
        this.randomData.reSeed(1000L);
        for (i = 0; i < 1000; ++i) {
            value = this.randomData.nextGamma(0.3, 3.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testNextT() {
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new TDistribution(10.0));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (int i = 0; i < 1000; ++i) {
            double value = this.randomData.nextT(10.0);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testNextWeibull() {
        double[] quartiles = TestUtils.getDistributionQuartiles((RealDistribution)new WeibullDistribution(1.2, 2.1));
        long[] counts = new long[4];
        this.randomData.reSeed(1000L);
        for (int i = 0; i < 1000; ++i) {
            double value = this.randomData.nextWeibull(1.2, 2.1);
            TestUtils.updateCounts(value, counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(this.expected, counts, 0.001);
    }

    @Test
    public void testNextBinomial() {
        int i;
        BinomialDistributionTest testInstance = new BinomialDistributionTest();
        int[] densityPoints = testInstance.makeDensityTestPoints();
        double[] densityValues = testInstance.makeDensityTestValues();
        int sampleSize = 1000;
        int length = TestUtils.eliminateZeroMassPoints(densityPoints, densityValues);
        BinomialDistribution distribution = (BinomialDistribution)testInstance.makeDistribution();
        double[] expectedCounts = new double[length];
        long[] observedCounts = new long[length];
        for (i = 0; i < length; ++i) {
            expectedCounts[i] = (double)sampleSize * densityValues[i];
        }
        this.randomData.reSeed(1000L);
        for (i = 0; i < sampleSize; ++i) {
            int value = this.randomData.nextBinomial(distribution.getNumberOfTrials(), distribution.getProbabilityOfSuccess());
            for (int j = 0; j < length; ++j) {
                if (value != densityPoints[j]) continue;
                int n = j;
                observedCounts[n] = observedCounts[n] + 1L;
            }
        }
        TestUtils.assertChiSquareAccept(densityPoints, expectedCounts, observedCounts, 0.001);
    }

    @Test
    public void testNextHypergeometric() {
        int i;
        HypergeometricDistributionTest testInstance = new HypergeometricDistributionTest();
        int[] densityPoints = testInstance.makeDensityTestPoints();
        double[] densityValues = testInstance.makeDensityTestValues();
        int sampleSize = 1000;
        int length = TestUtils.eliminateZeroMassPoints(densityPoints, densityValues);
        HypergeometricDistribution distribution = (HypergeometricDistribution)testInstance.makeDistribution();
        double[] expectedCounts = new double[length];
        long[] observedCounts = new long[length];
        for (i = 0; i < length; ++i) {
            expectedCounts[i] = (double)sampleSize * densityValues[i];
        }
        this.randomData.reSeed(1000L);
        for (i = 0; i < sampleSize; ++i) {
            int value = this.randomData.nextHypergeometric(distribution.getPopulationSize(), distribution.getNumberOfSuccesses(), distribution.getSampleSize());
            for (int j = 0; j < length; ++j) {
                if (value != densityPoints[j]) continue;
                int n = j;
                observedCounts[n] = observedCounts[n] + 1L;
            }
        }
        TestUtils.assertChiSquareAccept(densityPoints, expectedCounts, observedCounts, 0.001);
    }

    @Test
    public void testNextPascal() {
        int i;
        PascalDistributionTest testInstance = new PascalDistributionTest();
        int[] densityPoints = testInstance.makeDensityTestPoints();
        double[] densityValues = testInstance.makeDensityTestValues();
        int sampleSize = 1000;
        int length = TestUtils.eliminateZeroMassPoints(densityPoints, densityValues);
        PascalDistribution distribution = (PascalDistribution)testInstance.makeDistribution();
        double[] expectedCounts = new double[length];
        long[] observedCounts = new long[length];
        for (i = 0; i < length; ++i) {
            expectedCounts[i] = (double)sampleSize * densityValues[i];
        }
        this.randomData.reSeed(1000L);
        for (i = 0; i < sampleSize; ++i) {
            int value = this.randomData.nextPascal(distribution.getNumberOfSuccesses(), distribution.getProbabilityOfSuccess());
            for (int j = 0; j < length; ++j) {
                if (value != densityPoints[j]) continue;
                int n = j;
                observedCounts[n] = observedCounts[n] + 1L;
            }
        }
        TestUtils.assertChiSquareAccept(densityPoints, expectedCounts, observedCounts, 0.001);
    }

    @Test
    public void testNextZipf() {
        int i;
        ZipfDistributionTest testInstance = new ZipfDistributionTest();
        int[] densityPoints = testInstance.makeDensityTestPoints();
        double[] densityValues = testInstance.makeDensityTestValues();
        int sampleSize = 1000;
        int length = TestUtils.eliminateZeroMassPoints(densityPoints, densityValues);
        ZipfDistribution distribution = (ZipfDistribution)testInstance.makeDistribution();
        double[] expectedCounts = new double[length];
        long[] observedCounts = new long[length];
        for (i = 0; i < length; ++i) {
            expectedCounts[i] = (double)sampleSize * densityValues[i];
        }
        this.randomData.reSeed(1000L);
        for (i = 0; i < sampleSize; ++i) {
            int value = this.randomData.nextZipf(distribution.getNumberOfElements(), distribution.getExponent());
            for (int j = 0; j < length; ++j) {
                if (value != densityPoints[j]) continue;
                int n = j;
                observedCounts[n] = observedCounts[n] + 1L;
            }
        }
        TestUtils.assertChiSquareAccept(densityPoints, expectedCounts, observedCounts, 0.001);
    }

    @Test
    public void testReseed() {
        PoissonDistribution x = new PoissonDistribution(3.0);
        x.reseedRandomGenerator(0L);
        double u = x.sample();
        PoissonDistribution y = new PoissonDistribution(3.0);
        y.reseedRandomGenerator(0L);
        Assert.assertEquals((double)u, (double)y.sample(), (double)0.0);
    }
}

