/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.random;

import com.hazelcast.shaded.org.apache.commons.math3.random.RandomAdaptor;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class RandomAdaptorTest {
    @Test
    public void testAdaptor() {
        ConstantGenerator generator = new ConstantGenerator();
        Random random = RandomAdaptor.createAdaptor((RandomGenerator)generator);
        this.checkConstant(random);
        RandomAdaptor randomAdaptor = new RandomAdaptor((RandomGenerator)generator);
        this.checkConstant((Random)randomAdaptor);
    }

    private void checkConstant(Random random) {
        byte[] bytes = new byte[]{0};
        random.nextBytes(bytes);
        Assert.assertEquals((long)0L, (long)bytes[0]);
        Assert.assertFalse((boolean)random.nextBoolean());
        Assert.assertEquals((double)0.0, (double)random.nextDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)random.nextFloat(), (float)0.0f);
        Assert.assertEquals((double)0.0, (double)random.nextGaussian(), (double)0.0);
        Assert.assertEquals((long)0L, (long)random.nextInt());
        Assert.assertEquals((long)0L, (long)random.nextInt(1));
        Assert.assertEquals((long)0L, (long)random.nextLong());
        random.setSeed(100L);
        Assert.assertEquals((double)0.0, (double)random.nextDouble(), (double)0.0);
    }

    public static class ConstantGenerator
    implements RandomGenerator {
        private final double value;

        public ConstantGenerator() {
            this.value = 0.0;
        }

        public ConstantGenerator(double value) {
            this.value = value;
        }

        public boolean nextBoolean() {
            return false;
        }

        public void nextBytes(byte[] bytes) {
        }

        public double nextDouble() {
            return this.value;
        }

        public float nextFloat() {
            return (float)this.value;
        }

        public double nextGaussian() {
            return this.value;
        }

        public int nextInt() {
            return (int)this.value;
        }

        public int nextInt(int n) {
            return (int)this.value;
        }

        public long nextLong() {
            return (int)this.value;
        }

        public void setSeed(int seed) {
        }

        public void setSeed(int[] seed) {
        }

        public void setSeed(long seed) {
        }
    }
}

