/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization.general;

import com.hazelcast.shaded.org.apache.commons.math3.optimization.PointVectorValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.AbstractLeastSquaresOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.StatisticalReferenceDataset;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.StatisticalReferenceDatasetFactory;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class AbstractLeastSquaresOptimizerTest {
    public static AbstractLeastSquaresOptimizer createOptimizer() {
        return new AbstractLeastSquaresOptimizer(null){

            protected PointVectorValuePair doOptimize() {
                double[] params = this.getStartPoint();
                double[] res = this.computeResiduals(this.computeObjectiveValue(params));
                this.setCost(this.computeCost(res));
                return new PointVectorValuePair(params, null);
            }
        };
    }

    @Test
    public void testGetChiSquare() throws IOException {
        StatisticalReferenceDataset dataset = StatisticalReferenceDatasetFactory.createKirby2();
        AbstractLeastSquaresOptimizer optimizer = AbstractLeastSquaresOptimizerTest.createOptimizer();
        double[] a = dataset.getParameters();
        double[] y = dataset.getData()[1];
        double[] w = new double[y.length];
        Arrays.fill(w, 1.0);
        optimizer.optimize(1, dataset.getLeastSquaresProblem(), y, w, a);
        double expected = dataset.getResidualSumOfSquares();
        double actual = optimizer.getChiSquare();
        Assert.assertEquals((String)dataset.getName(), (double)expected, (double)actual, (double)(1.0E-11 * expected));
    }

    @Test
    public void testGetRMS() throws IOException {
        StatisticalReferenceDataset dataset = StatisticalReferenceDatasetFactory.createKirby2();
        AbstractLeastSquaresOptimizer optimizer = AbstractLeastSquaresOptimizerTest.createOptimizer();
        double[] a = dataset.getParameters();
        double[] y = dataset.getData()[1];
        double[] w = new double[y.length];
        Arrays.fill(w, 1.0);
        optimizer.optimize(1, dataset.getLeastSquaresProblem(), y, w, a);
        double expected = FastMath.sqrt((double)(dataset.getResidualSumOfSquares() / (double)dataset.getNumObservations()));
        double actual = optimizer.getRMS();
        Assert.assertEquals((String)dataset.getName(), (double)expected, (double)actual, (double)(1.0E-11 * expected));
    }

    @Test
    public void testComputeSigma() throws IOException {
        StatisticalReferenceDataset dataset = StatisticalReferenceDatasetFactory.createKirby2();
        AbstractLeastSquaresOptimizer optimizer = AbstractLeastSquaresOptimizerTest.createOptimizer();
        double[] a = dataset.getParameters();
        double[] y = dataset.getData()[1];
        double[] w = new double[y.length];
        Arrays.fill(w, 1.0);
        int dof = y.length - a.length;
        PointVectorValuePair optimum = optimizer.optimize(1, dataset.getLeastSquaresProblem(), y, w, a);
        double[] sig = optimizer.computeSigma(optimum.getPoint(), 1.0E-14);
        double[] expected = dataset.getParametersStandardDeviations();
        for (int i = 0; i < sig.length; ++i) {
            double actual = FastMath.sqrt((double)(optimizer.getChiSquare() / (double)dof)) * sig[i];
            Assert.assertEquals((String)(dataset.getName() + ", parameter #" + i), (double)expected[i], (double)actual, (double)(1.0E-7 * expected[i]));
        }
    }
}

