/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateVectorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalStateException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.BlockRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.ConvergenceChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.MultivariateDifferentiableVectorMultiStartOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.MultivariateDifferentiableVectorOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.PointVectorValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.SimpleVectorValueChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.GaussNewtonOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.random.GaussianRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.JDKRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.NormalizedRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomVectorGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.UncorrelatedRandomVectorGenerator;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class MultivariateDifferentiableVectorMultiStartOptimizerTest {
    @Test
    public void testTrivial() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0}}, new double[]{3.0});
        MultivariateDifferentiableVectorOptimizer underlyingOptimizer = new MultivariateDifferentiableVectorOptimizer(){
            private GaussNewtonOptimizer gn = new GaussNewtonOptimizer(true, (ConvergenceChecker)new SimpleVectorValueChecker(1.0E-6, 1.0E-6));

            public PointVectorValuePair optimize(int maxEval, MultivariateDifferentiableVectorFunction f, double[] target, double[] weight, double[] startPoint) {
                return this.gn.optimize(maxEval, f, target, weight, startPoint);
            }

            public int getMaxEvaluations() {
                return this.gn.getMaxEvaluations();
            }

            public int getEvaluations() {
                return this.gn.getEvaluations();
            }

            public ConvergenceChecker<PointVectorValuePair> getConvergenceChecker() {
                return this.gn.getConvergenceChecker();
            }
        };
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(16069223052L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(1, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        MultivariateDifferentiableVectorMultiStartOptimizer optimizer = new MultivariateDifferentiableVectorMultiStartOptimizer(underlyingOptimizer, 10, (RandomVectorGenerator)generator);
        try {
            optimizer.getOptima();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            // empty catch block
        }
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateVectorFunction)problem, problem.target, new double[]{1.0}, new double[]{0.0});
        Assert.assertEquals((double)1.5, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getValue()[0], (double)1.0E-10);
        PointVectorValuePair[] optima = optimizer.getOptima();
        Assert.assertEquals((long)10L, (long)optima.length);
        for (int i = 0; i < optima.length; ++i) {
            Assert.assertEquals((double)1.5, (double)optima[i].getPoint()[0], (double)1.0E-10);
            Assert.assertEquals((double)3.0, (double)optima[i].getValue()[0], (double)1.0E-10);
        }
        Assert.assertTrue((optimizer.getEvaluations() > 20 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 50 ? 1 : 0) != 0);
        Assert.assertEquals((long)100L, (long)optimizer.getMaxEvaluations());
    }

    @Test(expected=TestException.class)
    public void testNoOptimum() {
        MultivariateDifferentiableVectorOptimizer underlyingOptimizer = new MultivariateDifferentiableVectorOptimizer(){
            private GaussNewtonOptimizer gn = new GaussNewtonOptimizer(true, (ConvergenceChecker)new SimpleVectorValueChecker(1.0E-6, 1.0E-6));

            public PointVectorValuePair optimize(int maxEval, MultivariateDifferentiableVectorFunction f, double[] target, double[] weight, double[] startPoint) {
                return this.gn.optimize(maxEval, f, target, weight, startPoint);
            }

            public int getMaxEvaluations() {
                return this.gn.getMaxEvaluations();
            }

            public int getEvaluations() {
                return this.gn.getEvaluations();
            }

            public ConvergenceChecker<PointVectorValuePair> getConvergenceChecker() {
                return this.gn.getConvergenceChecker();
            }
        };
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(12373523445L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(1, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        MultivariateDifferentiableVectorMultiStartOptimizer optimizer = new MultivariateDifferentiableVectorMultiStartOptimizer(underlyingOptimizer, 10, (RandomVectorGenerator)generator);
        optimizer.optimize(100, (MultivariateVectorFunction)new MultivariateDifferentiableVectorFunction(){

            public double[] value(double[] point) {
                throw new TestException();
            }

            public DerivativeStructure[] value(DerivativeStructure[] point) {
                return point;
            }
        }, new double[]{2.0}, new double[]{1.0}, new double[]{0.0});
    }

    private static class LinearProblem
    implements MultivariateDifferentiableVectorFunction {
        final RealMatrix factors;
        final double[] target;

        public LinearProblem(double[][] factors, double[] target) {
            this.factors = new BlockRealMatrix(factors);
            this.target = target;
        }

        public double[] value(double[] variables) {
            return this.factors.operate(variables);
        }

        public DerivativeStructure[] value(DerivativeStructure[] variables) {
            DerivativeStructure[] y = new DerivativeStructure[this.factors.getRowDimension()];
            for (int i = 0; i < y.length; ++i) {
                y[i] = (DerivativeStructure)variables[0].getField().getZero();
                for (int j = 0; j < this.factors.getColumnDimension(); ++j) {
                    y[i] = y[i].add(variables[j].multiply(this.factors.getEntry(i, j)));
                }
            }
            return y;
        }
    }

    private static class TestException
    extends RuntimeException {
        private static final long serialVersionUID = -7809988995389067683L;

        private TestException() {
        }
    }
}

