/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateVectorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.ModelFunction;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.ModelFunctionJacobian;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.ArrayList;

@Deprecated
class CircleProblem {
    private final ArrayList<double[]> points = new ArrayList();
    private final double xSigma;
    private final double ySigma;
    private final int resolution;

    public CircleProblem(double xError, double yError, int searchResolution) {
        this.xSigma = xError;
        this.ySigma = yError;
        this.resolution = searchResolution;
    }

    public CircleProblem(double xError, double yError) {
        this(xError, yError, 500);
    }

    public void addPoint(double px, double py) {
        this.points.add(new double[]{px, py});
    }

    public double[] target() {
        double[] t = new double[this.points.size() * 2];
        for (int i = 0; i < this.points.size(); ++i) {
            double[] p = this.points.get(i);
            int index = i * 2;
            t[index] = p[0];
            t[index + 1] = p[1];
        }
        return t;
    }

    public double[] weight() {
        double wX = 1.0 / (this.xSigma * this.xSigma);
        double wY = 1.0 / (this.ySigma * this.ySigma);
        double[] w = new double[this.points.size() * 2];
        for (int i = 0; i < this.points.size(); ++i) {
            int index = i * 2;
            w[index] = wX;
            w[index + 1] = wY;
        }
        return w;
    }

    public ModelFunction getModelFunction() {
        return new ModelFunction(new MultivariateVectorFunction(){

            public double[] value(double[] params) {
                double cx = params[0];
                double cy = params[1];
                double r = params[2];
                double[] model = new double[CircleProblem.this.points.size() * 2];
                double deltaTheta = Math.PI * 2 / (double)CircleProblem.this.resolution;
                for (int i = 0; i < CircleProblem.this.points.size(); ++i) {
                    double[] p = (double[])CircleProblem.this.points.get(i);
                    double px = p[0];
                    double py = p[1];
                    double bestX = 0.0;
                    double bestY = 0.0;
                    double dMin = Double.POSITIVE_INFINITY;
                    for (double theta = 0.0; theta <= Math.PI * 2; theta += deltaTheta) {
                        double currentY;
                        double dY;
                        double currentX = cx + r * FastMath.cos((double)theta);
                        double dX = currentX - px;
                        double d = dX * dX + (dY = (currentY = cy + r * FastMath.sin((double)theta)) - py) * dY;
                        if (!(d < dMin)) continue;
                        dMin = d;
                        bestX = currentX;
                        bestY = currentY;
                    }
                    int index = i * 2;
                    model[index] = bestX;
                    model[index + 1] = bestY;
                }
                return model;
            }
        });
    }

    public ModelFunctionJacobian getModelFunctionJacobian() {
        return new ModelFunctionJacobian(new MultivariateMatrixFunction(){

            public double[][] value(double[] point) {
                return CircleProblem.this.jacobian(point);
            }
        });
    }

    private double[][] jacobian(double[] params) {
        double[][] jacobian = new double[this.points.size() * 2][3];
        for (int i = 0; i < this.points.size(); ++i) {
            int index = i * 2;
            jacobian[index][0] = 1.0;
            jacobian[index + 1][0] = 0.0;
            jacobian[index][1] = 0.0;
            jacobian[index + 1][1] = 1.0;
            double[] p = this.points.get(i);
            jacobian[index][2] = (p[0] - params[0]) / params[2];
            jacobian[index + 1][2] = (p[1] - params[1]) / params[2];
        }
        return jacobian;
    }
}

